/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import java.io.Serializable;
import lombok.Generated;
import org.anchoranalysis.spatial.point.Point2i;

public final class Point2d
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double x;
    private double y;

    public Point2d(Point2d point) {
        this.x = point.x;
        this.y = point.y;
    }

    public void add(Point2i toAdd) {
        this.add(toAdd.x(), toAdd.y());
    }

    public void add(Point2d toAdd) {
        this.add(toAdd.x(), toAdd.y());
    }

    public void add(int xToAdd, int yToAdd) {
        this.x += (double)xToAdd;
        this.y += (double)yToAdd;
    }

    public void add(double xToAdd, double yToAdd) {
        this.x += xToAdd;
        this.y += yToAdd;
    }

    public void scale(double factor) {
        this.x *= factor;
        this.y *= factor;
    }

    public double distance(Point2d point) {
        return Math.sqrt(this.distanceSquared(point));
    }

    public double distanceSquared(Point2d point) {
        double sx = this.x - point.x;
        double sy = this.y - point.y;
        return sx * sx + sy * sy;
    }

    public String toString() {
        return String.format("[%f,%f]", this.x, this.y);
    }

    @Generated
    public Point2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point2d)) {
            return false;
        }
        Point2d other = (Point2d)o;
        if (Double.compare(this.x(), other.x()) != 0) {
            return false;
        }
        return Double.compare(this.y(), other.y()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.x());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.y());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        return result;
    }

    @Generated
    public Point2d() {
    }

    @Generated
    public double x() {
        return this.x;
    }

    @Generated
    public double y() {
        return this.y;
    }
}

