/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.orientation;

import cern.colt.matrix.DoubleMatrix2D;
import lombok.Generated;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.RotationMatrix;
import org.anchoranalysis.spatial.point.Vector3d;

public final class OrientationAxisAngle
extends Orientation {
    private static final long serialVersionUID = -2592680414423106545L;
    private final Vector3d axis;
    private final double angle;

    public String toString() {
        return String.format("angle=%f axis=%s", this.angle, this.axis.toString());
    }

    @Override
    protected RotationMatrix deriveRotationMatrix() {
        RotationMatrix rotationMatrix = new RotationMatrix(this.numberDimensions());
        DoubleMatrix2D matrix = rotationMatrix.getMatrix();
        double oneMinusCos = 1.0 - Math.cos(this.angle);
        double cos = Math.cos(this.angle);
        double sin = Math.sin(this.angle);
        matrix.set(0, 0, cos + this.axis.x() * this.axis.x() * oneMinusCos);
        matrix.set(1, 0, this.axis.y() * this.axis.x() * oneMinusCos + this.axis.z() * sin);
        matrix.set(2, 0, this.axis.z() * this.axis.x() * oneMinusCos - this.axis.y() * sin);
        matrix.set(0, 1, this.axis.x() * this.axis.y() * oneMinusCos - this.axis.z() * sin);
        matrix.set(1, 1, cos + this.axis.y() * this.axis.y() * oneMinusCos);
        matrix.set(2, 1, this.axis.z() * this.axis.y() * oneMinusCos + this.axis.x() * sin);
        matrix.set(0, 2, this.axis.x() * this.axis.z() * oneMinusCos + this.axis.y() * sin);
        matrix.set(1, 2, this.axis.y() * this.axis.z() * oneMinusCos - this.axis.x() * sin);
        matrix.set(2, 2, cos + this.axis.z() * this.axis.z() * oneMinusCos);
        return rotationMatrix;
    }

    @Override
    public Orientation negative() {
        return new OrientationAxisAngle(new Vector3d(this.axis), this.angle + Math.PI);
    }

    @Override
    public int numberDimensions() {
        return 3;
    }

    @Generated
    public OrientationAxisAngle(Vector3d axis, double angle) {
        this.axis = axis;
        this.angle = angle;
    }

    @Generated
    public Vector3d getAxis() {
        return this.axis;
    }

    @Generated
    public double getAngle() {
        return this.angle;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrientationAxisAngle)) {
            return false;
        }
        OrientationAxisAngle other = (OrientationAxisAngle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAngle(), other.getAngle()) != 0) {
            return false;
        }
        Vector3d this$axis = this.getAxis();
        Vector3d other$axis = other.getAxis();
        return !(this$axis == null ? other$axis != null : !((Object)this$axis).equals(other$axis));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OrientationAxisAngle;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $angle = Double.doubleToLongBits(this.getAngle());
        result = result * 59 + (int)($angle >>> 32 ^ $angle);
        Vector3d $axis = this.getAxis();
        result = result * 59 + ($axis == null ? 43 : ((Object)$axis).hashCode());
        return result;
    }
}

