/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.orientation;

import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.Tuple3d;
import org.anchoranalysis.spatial.point.Vector3d;

public final class DirectionVector {
    private final Tuple3d vector;

    public DirectionVector() {
        this.vector = new Vector3d();
    }

    public DirectionVector(Tuple3d vector) {
        this.vector = vector;
    }

    public DirectionVector(double x, double y, double z) {
        this.vector = new Vector3d(x, y, z);
    }

    public DirectionVector(Axis axis) {
        this.vector = switch (axis) {
            case Axis.X -> new Point3d(1.0, 0.0, 0.0);
            case Axis.Y -> new Point3d(0.0, 1.0, 0.0);
            case Axis.Z -> new Point3d(0.0, 0.0, 1.0);
            default -> throw new AnchorImpossibleSituationException();
        };
    }

    public static DirectionVector createBetweenTwoPoints(Point3d point1, Point3d point2) {
        double sx = point2.x() - point1.x();
        double sy = point2.y() - point1.y();
        double sz = point2.z() - point1.z();
        return DirectionVector.createNormed(sx, sy, sz);
    }

    public static DirectionVector createBetweenTwoPoints(Point3i point1, Point3i point2) {
        double sx = (double)point2.x() - (double)point1.x();
        double sy = (double)point2.y() - (double)point1.y();
        double sz = (double)point2.z() - (double)point1.z();
        return DirectionVector.createNormed(sx, sy, sz);
    }

    public double x() {
        return this.vector.x();
    }

    public double y() {
        return this.vector.y();
    }

    public double z() {
        return this.vector.z();
    }

    public void setIndex(int index, double valueToAssign) {
        switch (index) {
            case 0: {
                this.vector.setX(valueToAssign);
                break;
            }
            case 1: {
                this.vector.setY(valueToAssign);
                break;
            }
            case 2: {
                this.vector.setZ(valueToAssign);
                break;
            }
            default: {
                throw new AnchorFriendlyRuntimeException("Index must be >= 0 and < 3");
            }
        }
    }

    public Vector3d asVector3d() {
        return new Vector3d(this.vector);
    }

    private static DirectionVector createNormed(double x, double y, double z) {
        double norm = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
        return new DirectionVector(x / norm, y / norm, z / norm);
    }
}

