/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import lombok.Generated;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class ClampToUtilities {
    public static Point3i limitToExtent(ReadableTuple3i point, Extent extent) {
        Point3i copy = new Point3i(point);
        if (copy.x() >= extent.x()) {
            copy.setX(extent.x() - 1);
        }
        if (copy.y() >= extent.y()) {
            copy.setY(extent.y() - 1);
        }
        if (copy.z() >= extent.z()) {
            copy.setZ(extent.z() - 1);
        }
        return copy;
    }

    public static Point3i replaceNegativeWithZero(Point3i point) {
        Point3i copy = new Point3i(point);
        if (copy.x() < 0) {
            copy.setX(0);
        }
        if (copy.y() < 0) {
            copy.setY(0);
        }
        if (copy.z() < 0) {
            copy.setZ(0);
        }
        return copy;
    }

    public static boolean pointNonZero(ReadableTuple3i point) {
        return point.matchAllDimensions(value -> value >= 0);
    }

    public static boolean pointLessThan(ReadableTuple3i point, Extent extent) {
        return point.matchAllDimensions(extent.asTuple(), (value1, value2) -> value1 < value2);
    }

    @Generated
    private ClampToUtilities() {
    }
}

