/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import java.util.function.ToIntFunction;
import lombok.Generated;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.ExtentBoundsComparer;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class BoundingBoxUnion {
    private final BoundingBox box;

    public BoundingBox with(BoundingBox other) {
        ReadableTuple3i cornerMin = this.box.cornerMin();
        ReadableTuple3i cornerMinOther = other.cornerMin();
        ReadableTuple3i cornerMax = this.box.calculateCornerMaxInclusive();
        ReadableTuple3i cornerMaxOther = other.calculateCornerMaxInclusive();
        ExtentBoundsComparer comparerX = ExtentBoundsComparer.createMax(cornerMin, cornerMinOther, cornerMax, cornerMaxOther, ReadableTuple3i::x);
        ExtentBoundsComparer comparerY = ExtentBoundsComparer.createMax(cornerMin, cornerMinOther, cornerMax, cornerMaxOther, ReadableTuple3i::y);
        ExtentBoundsComparer comparerZ = ExtentBoundsComparer.createMax(cornerMin, cornerMinOther, cornerMax, cornerMaxOther, ReadableTuple3i::z);
        return BoundingBox.createReuse((ReadableTuple3i)BoundingBoxUnion.extractPoint(comparerX, comparerY, comparerZ, ExtentBoundsComparer::min), BoundingBoxUnion.extractPoint(comparerX, comparerY, comparerZ, ExtentBoundsComparer::max));
    }

    private static Point3i extractPoint(ExtentBoundsComparer comparerX, ExtentBoundsComparer comparerY, ExtentBoundsComparer comparerZ, ToIntFunction<ExtentBoundsComparer> extract) {
        return new Point3i(extract.applyAsInt(comparerX), extract.applyAsInt(comparerY), extract.applyAsInt(comparerZ));
    }

    @Generated
    public BoundingBoxUnion(BoundingBox box) {
        this.box = box;
    }
}

