/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public final class BoundingBoxContains {
    private final BoundingBox box;
    private final ReadableTuple3i cornerMax;

    public BoundingBoxContains(BoundingBox box) {
        this.box = box;
        this.cornerMax = box.calculateCornerMaxInclusive();
    }

    public boolean x(int value) {
        return value >= this.box.cornerMin().x() && value <= this.cornerMax.x();
    }

    public boolean y(int value) {
        return value >= this.box.cornerMin().y() && value <= this.cornerMax.y();
    }

    public boolean z(int value) {
        return value >= this.box.cornerMin().z() && value <= this.cornerMax.z();
    }

    public boolean point(ReadableTuple3i point) {
        return this.x(point.x()) && this.y(point.y()) && this.z(point.z());
    }

    public boolean pointIgnoreZ(Point3i point) {
        return this.x(point.x()) && this.y(point.y());
    }

    public boolean box(BoundingBox maybeContainedInside) {
        return this.point(maybeContainedInside.cornerMin()) && this.point(maybeContainedInside.calculateCornerMaxInclusive());
    }
}

