/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.axis;

import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.axis.AxisConversionException;

public class AxisConverter {
    public static final String INVALID_AXIS_STRING = "axis must be: x or y or z";
    public static final String INVALID_AXIS_INDEX = "the index for axis must be: 0 or 1 or 2";

    public static Axis createFromString(String axisAsString) throws AxisConversionException {
        if ("x".equalsIgnoreCase(axisAsString)) {
            return Axis.X;
        }
        if ("y".equalsIgnoreCase(axisAsString)) {
            return Axis.Y;
        }
        if ("z".equalsIgnoreCase(axisAsString)) {
            return Axis.Z;
        }
        throw new AxisConversionException(INVALID_AXIS_STRING);
    }

    public static int dimensionIndexFor(Axis axis) throws AxisConversionException {
        switch (axis) {
            case X: {
                return 0;
            }
            case Y: {
                return 1;
            }
            case Z: {
                return 2;
            }
        }
        throw new AxisConversionException(INVALID_AXIS_INDEX);
    }

    public static int valueFor(Axis axis, int x, int y, int z) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        throw new AnchorImpossibleSituationException();
    }

    @Generated
    private AxisConverter() {
    }
}

