/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.scale;

import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class Scaler {
    public static Point3i scale(ScaleFactor scalingFactor, Point3i point) {
        return new Point3i(Scaler.scaleRound(scalingFactor.x(), point.x()), Scaler.scaleRound(scalingFactor.y(), point.y()), point.z());
    }

    public static Point3i scaleCeil(ScaleFactor scalingFactor, Point3i point) {
        return new Point3i(Scaler.scaleCeil(scalingFactor.x(), point.x()), Scaler.scaleCeil(scalingFactor.y(), point.y()), point.z());
    }

    public static int scaleMultiplex(double scalingFactor, int quantity, boolean round) {
        if (round) {
            return Scaler.scaleRound(scalingFactor, quantity);
        }
        return Scaler.scaleCeil(scalingFactor, quantity);
    }

    public static int scaleRound(double scalingFactor, int quantity) {
        int val = (int)Math.round(scalingFactor * (double)quantity);
        return Math.max(val, 1);
    }

    public static int scaleCeil(double scalingFactor, int quantity) {
        int val = (int)Math.ceil(scalingFactor * (double)quantity);
        return Math.max(val, 1);
    }

    public static int scaleFloor(double scalingFactor, int quantity) {
        int val = (int)Math.floor(scalingFactor * (double)quantity);
        return Math.max(val, 1);
    }

    public static double deriveScalingFactor(int numerator, int denominator) {
        return (double)numerator / (double)denominator;
    }

    private Scaler() {
    }
}

