/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.scale;

import com.google.common.base.Preconditions;
import org.anchoranalysis.spatial.point.Point3d;

public final class ScaleFactor {
    private final double x;
    private final double y;

    public ScaleFactor(double factor) {
        this(factor, factor);
    }

    public ScaleFactor(double x, double y) {
        Preconditions.checkArgument((x > 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((y > 0.0 ? 1 : 0) != 0);
        this.x = x;
        this.y = y;
    }

    public ScaleFactor invert() {
        return new ScaleFactor(1.0 / this.x, 1.0 / this.y);
    }

    public boolean hasIdenticalXY() {
        return Math.abs(this.x - this.y) < 0.001;
    }

    public boolean isNoScale() {
        return this.x == 1.0 && this.y == 1.0;
    }

    public double minimumDimension() {
        return Double.min(this.x, this.y);
    }

    public void scale(Point3d point) {
        point.setX(this.scaledX(point.x()));
        point.setY(this.scaledY(point.y()));
    }

    public String toString() {
        return String.format("x=%f\ty=%f\t\tx^-1=%f\ty^-1=%f", this.x, this.y, 1.0 / this.x, 1.0 / this.y);
    }

    private double scaledX(double value) {
        return value * this.x;
    }

    private double scaledY(double value) {
        return value * this.y;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaleFactor)) {
            return false;
        }
        ScaleFactor other = (ScaleFactor)o;
        if (Double.compare(this.x(), other.x()) != 0) {
            return false;
        }
        return Double.compare(this.y(), other.y()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.x());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.y());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        return result;
    }
}

