/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import org.anchoranalysis.spatial.point.Point3f;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.Tuple3d;
import org.anchoranalysis.spatial.point.Tuple3i;

public final class Point3d
extends Tuple3d {
    private static final long serialVersionUID = 1L;

    public Point3d(Point3f point) {
        this.x = point.x();
        this.y = point.y();
        this.z = point.z();
    }

    public Point3d(Tuple3d point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public Point3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double distance(Point3d point) {
        return Math.sqrt(this.distanceSquared(point));
    }

    public double distanceSquared(Point3d point) {
        double sx = this.x - point.x;
        double sy = this.y - point.y;
        double sz = this.z - point.z;
        return sx * sx + sy * sy + sz * sz;
    }

    public double distanceSquared(Point3i point) {
        double sx = this.x - (double)point.x;
        double sy = this.y - (double)point.y;
        double sz = this.z - (double)point.z;
        return sx * sx + sy * sy + sz * sz;
    }

    public Point3d dropZ() {
        return new Point3d(this.x, this.y, 0.0);
    }

    public Point3d min(Tuple3d point) {
        return new Point3d(Math.min(this.x, point.x), Math.min(this.y, point.y), Math.min(this.z, point.z));
    }

    public Point3d min(ReadableTuple3i point) {
        return new Point3d(Math.min(this.x, (double)point.x()), Math.min(this.y, (double)point.y()), Math.min(this.z, (double)point.z()));
    }

    public Point3d max(double val) {
        return new Point3d(Math.max(this.x, val), Math.max(this.y, val), Math.max(this.z, val));
    }

    public boolean equalsTolerance(Point3d other, double delta) {
        return Point3d.equalsTolerance(this.x, other.x, delta) && Point3d.equalsTolerance(this.y, other.y, delta) && Point3d.equalsTolerance(this.z, other.z, delta);
    }

    public double[] toArray() {
        double[] out = new double[]{this.x, this.y, this.z};
        return out;
    }

    public double[] toArrayXY() {
        double[] out = new double[]{this.x, this.y};
        return out;
    }

    public Point3d max(Tuple3d point) {
        return new Point3d(Math.max(this.x, point.x), Math.max(this.y, point.y), Math.max(this.z, point.z));
    }

    public static Point3d immutableAdd(Tuple3d tuple1, Tuple3d tuple2) {
        Point3d pointDup = new Point3d(tuple1);
        pointDup.add(tuple2);
        return pointDup;
    }

    public static Point3d immutableAdd(Point3d point, int x, int y, int z) {
        Point3d pointCopy = new Point3d(point);
        pointCopy.incrementX(x);
        pointCopy.incrementY(y);
        pointCopy.incrementZ(z);
        return pointCopy;
    }

    public static Point3d immutableSubtract(Tuple3d tuple, Tuple3d toSubtract) {
        Point3d pointDup = new Point3d(tuple);
        pointDup.subtract(toSubtract);
        return pointDup;
    }

    public static Point3d immutableSubtract(Tuple3i tuple, Tuple3d toSubtract) {
        Point3d point = PointConverter.doubleFromInt(tuple);
        point.subtract(toSubtract);
        return point;
    }

    public static Point3d immutableScale(Tuple3d tuple, int factor) {
        Point3d pointDup = new Point3d(tuple);
        pointDup.scale(factor);
        return pointDup;
    }

    private static boolean equalsTolerance(double value1, double value2, double delta) {
        return Math.abs(value1 - value2) < delta;
    }

    public Point3d() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point3d)) {
            return false;
        }
        Point3d other = (Point3d)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Point3d;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

