/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.orientation;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import java.io.Serializable;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Tuple3d;

public class RotationMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DoubleMatrix2D delegate;
    private final DoubleMatrix2D singlePoint;

    public RotationMatrix(int numberDimensions) {
        this.delegate = DoubleFactory2D.dense.make(numberDimensions, numberDimensions);
        this.singlePoint = DoubleFactory2D.dense.make(numberDimensions, 1);
    }

    public RotationMatrix(DoubleMatrix2D matrix) {
        this.delegate = matrix;
        this.singlePoint = DoubleFactory2D.dense.make(matrix.rows(), 1);
    }

    public Point3d rotatePoint(Tuple3d point) {
        Point3d copy = new Point3d(point);
        this.rotatePointInplace(copy);
        return copy;
    }

    public void rotatePointInplace(Point3d point) {
        DoubleMatrix2D matrixIn = this.matrixFromPoint(point);
        this.delegate.zMult(matrixIn, this.singlePoint);
        this.assignToPointFromMatrix(this.singlePoint, point);
    }

    public Point3d column(int columnIndex) throws OperationFailedException {
        if (this.delegate.columns() != 3) {
            throw new OperationFailedException("The rotation-matrix is not three-dimensional");
        }
        DoubleMatrix1D vector = this.delegate.viewColumn(columnIndex);
        return new Point3d(vector.get(0), vector.get(1), vector.get(2));
    }

    public int getNumberDimensions() {
        return this.delegate.columns();
    }

    public DoubleMatrix2D getMatrix() {
        return this.delegate;
    }

    public void multiplyByConstant(double value) {
        this.delegate.assign(Functions.mult((double)value));
    }

    public RotationMatrix transpose() {
        return new RotationMatrix(this.delegate.viewDice().copy());
    }

    public RotationMatrix duplicate() {
        return new RotationMatrix(this.delegate.copy());
    }

    public String toString() {
        return this.delegate.toString();
    }

    private DoubleMatrix2D matrixFromPoint(Point3d point) {
        int dimensions = this.delegate.rows();
        DoubleMatrix2D matrixIn = DoubleFactory2D.dense.make(dimensions, 1);
        matrixIn.set(0, 0, point.x());
        matrixIn.set(1, 0, point.y());
        if (dimensions == 3) {
            matrixIn.set(2, 0, point.z());
        }
        return matrixIn;
    }

    private void assignToPointFromMatrix(DoubleMatrix2D matrixOut, Point3d point) {
        point.setX(matrixOut.get(0, 0));
        point.setY(matrixOut.get(1, 0));
        if (this.delegate.rows() == 3) {
            point.setZ(matrixOut.get(2, 0));
        }
    }
}

