/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.orientation;

import cern.colt.matrix.DoubleMatrix2D;
import org.anchoranalysis.spatial.orientation.IndexCalculator;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.RotationMatrix;

public class Orientation2D
extends Orientation {
    private static final long serialVersionUID = 1528190376087281572L;
    private double angleRadians = 0.0;

    public double getAngleDegrees() {
        return this.angleRadians * 180.0 / Math.PI;
    }

    @Override
    public Orientation2D negative() {
        return new Orientation2D((this.angleRadians + Math.PI) % (Math.PI * 2));
    }

    @Override
    protected RotationMatrix deriveRotationMatrix() {
        RotationMatrix rotationMatrix = new RotationMatrix(this.numberDimensions());
        IndexCalculator index = new IndexCalculator(0, 2);
        DoubleMatrix2D matrix = rotationMatrix.getMatrix();
        matrix.set(index.calculate(0), index.calculate(0), Math.cos(this.angleRadians));
        matrix.set(index.calculate(0), index.calculate(1), -1.0 * Math.sin(this.angleRadians));
        matrix.set(index.calculate(1), index.calculate(0), Math.sin(this.angleRadians));
        matrix.set(index.calculate(1), index.calculate(1), Math.cos(this.angleRadians));
        return rotationMatrix;
    }

    public String toString() {
        return String.format("[rad=%f]", this.angleRadians);
    }

    @Override
    public int numberDimensions() {
        return 2;
    }

    public Orientation2D(double angleRadians) {
        this.angleRadians = angleRadians;
    }

    public Orientation2D() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Orientation2D)) {
            return false;
        }
        Orientation2D other = (Orientation2D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.angleRadians, other.angleRadians) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Orientation2D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $angleRadians = Double.doubleToLongBits(this.angleRadians);
        result = result * 59 + (int)($angleRadians >>> 32 ^ $angleRadians);
        return result;
    }
}

