/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public final class PointRange {
    private Point3i min;
    private Point3i max;

    public void add(ReadableTuple3i point) {
        this.add(point.x(), point.y(), point.z());
    }

    public void add(int x, int y, int z) {
        if (this.max == null || this.min == null) {
            this.max = new Point3i(x, y, z);
            this.min = new Point3i(x, y, z);
            return;
        }
        if (x < this.min.x()) {
            this.min.setX(x);
        } else if (x > this.max.x()) {
            this.max.setX(x);
        }
        if (y < this.min.y()) {
            this.min.setY(y);
        } else if (y > this.max.y()) {
            this.max.setY(y);
        }
        if (z < this.min.z()) {
            this.min.setZ(z);
        } else if (z > this.max.z()) {
            this.max.setZ(z);
        }
    }

    public BoundingBox toBoundingBox() throws OperationFailedException {
        if (this.min == null || this.max == null) {
            throw new OperationFailedException("No point has been added, so no bounding-box can be derived");
        }
        return this.toBoundingBoxNoCheck();
    }

    public BoundingBox toBoundingBoxNoCheck() {
        return BoundingBox.createDuplicate((ReadableTuple3i)this.min, this.max);
    }

    public boolean isEmpty() {
        return this.min == null || this.max == null;
    }
}

