/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class BoundingBoxDistance {
    public static double distance(BoundingBox box1, BoundingBox box2, boolean includeZ) {
        if (box1.intersection().existsWith(box2)) {
            return 0.0;
        }
        ReadableTuple3i box1CornerMin = box1.cornerMin();
        ReadableTuple3i box1CornerMax = box1.calculateCornerMaxInclusive();
        ReadableTuple3i box2CornerMin = box2.cornerMin();
        ReadableTuple3i box2CornerMax = box2.calculateCornerMaxInclusive();
        int xDistance = BoundingBoxDistance.minDistance(box1CornerMin.x(), box1CornerMax.x(), box2CornerMin.x(), box2CornerMax.x());
        int yDistance = BoundingBoxDistance.minDistance(box1CornerMin.y(), box1CornerMax.y(), box2CornerMin.y(), box2CornerMax.y());
        int zDistance = 0;
        if (includeZ) {
            zDistance = BoundingBoxDistance.minDistance(box1CornerMin.z(), box1CornerMax.z(), box2CornerMin.z(), box2CornerMax.z());
        }
        return Math.sqrt(Math.pow(xDistance, 2.0) + Math.pow(yDistance, 2.0) + Math.pow(zDistance, 2.0));
    }

    private static int minDistance(int box1Min, int box1Max, int box2Min, int box2Max) {
        if (box2Min >= box1Min && box2Min <= box1Max) {
            return 0;
        }
        if (box1Min >= box2Min && box1Min <= box2Max) {
            return 0;
        }
        if (box2Max >= box1Min && box2Max <= box1Max) {
            return 0;
        }
        if (box1Max >= box2Min && box1Max <= box2Max) {
            return 0;
        }
        int diff1 = Math.abs(box1Min - box2Max);
        int diff2 = Math.abs(box2Min - box1Max);
        int diff3 = Math.abs(box1Min - box2Min);
        int diff4 = Math.abs(box1Max - box2Max);
        return Math.min(Math.min(diff1, diff2), Math.min(diff3, diff4));
    }

    private BoundingBoxDistance() {
    }
}

