/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.box;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.BoundingBoxMerger;

public class BoundedList<T> {
    private final List<T> list;
    private final BoundingBox boundingBox;
    private final Function<T, BoundingBox> extractBoundingBox;

    public static <T> BoundedList<T> createSingle(T element, Function<T, BoundingBox> extractBoundingBox) {
        return new BoundedList<Object>(Arrays.asList(element), extractBoundingBox.apply(element), extractBoundingBox);
    }

    public static <T> BoundedList<T> createFromList(List<T> list, Function<T, BoundingBox> extractBoundingBox) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        BoundingBox mergedBox = BoundingBoxMerger.merge(list.stream().map(extractBoundingBox));
        return new BoundedList<T>(list, mergedBox, extractBoundingBox);
    }

    public BoundedList<T> assignBoundingBox(BoundingBox boxToAssign) {
        Preconditions.checkArgument((boolean)boxToAssign.contains().box(this.boundingBox));
        return new BoundedList<T>(this.list, boxToAssign, this.extractBoundingBox);
    }

    public BoundedList<T> assignBoundingBoxAndMap(BoundingBox boxToAssign, UnaryOperator<T> mappingFunction) {
        return new BoundedList<T>(FunctionalList.mapToList(this.list, mappingFunction), boxToAssign, this.extractBoundingBox);
    }

    public BoundedList<T> addObjectsNoBoundingBoxChange(Collection<T> elementsToAdd) {
        this.list.addAll(elementsToAdd);
        return new BoundedList<T>(this.list, this.boundingBox, this.extractBoundingBox);
    }

    public int size() {
        return this.list.size();
    }

    public T get(int index) {
        return this.list.get(index);
    }

    public Stream<T> stream() {
        return this.list.stream();
    }

    private BoundedList(List<T> list, BoundingBox boundingBox, Function<T, BoundingBox> extractBoundingBox) {
        this.list = list;
        this.boundingBox = boundingBox;
        this.extractBoundingBox = extractBoundingBox;
    }

    public List<T> list() {
        return this.list;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }
}

