/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.pair;

import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;

public class PairVoxelizedMarkMemo {
    private final VoxelizedMarkMemo source;
    private final VoxelizedMarkMemo destination;

    public PairVoxelizedMarkMemo(VoxelizedMarkMemo source, VoxelizedMarkMemo destination) {
        if (source.getMark().getIdentifier() < destination.getMark().getIdentifier()) {
            this.source = source;
            this.destination = destination;
        } else {
            this.destination = source;
            this.source = destination;
        }
    }

    public boolean equals(Object othero) {
        if (othero == null) {
            return false;
        }
        if (othero == this) {
            return true;
        }
        if (!(othero instanceof PairVoxelizedMarkMemo)) {
            return false;
        }
        PairVoxelizedMarkMemo other = (PairVoxelizedMarkMemo)othero;
        return this.source.equals(other.source) && this.destination.equals(other.destination);
    }

    public int hashCode() {
        return this.source.getMark().getIdentifier() * 3 + this.destination.getMark().getIdentifier();
    }

    public VoxelizedMarkMemo getSource() {
        return this.source;
    }

    public VoxelizedMarkMemo getDestination() {
        return this.destination;
    }

    public String toString() {
        return String.format("%d--%d", this.source.getMark().getIdentifier(), this.destination.getMark().getIdentifier());
    }
}

