/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.voxelized;

import java.util.List;
import java.util.function.IntConsumer;
import lombok.Generated;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipWithFlags;
import org.anchoranalysis.mpp.index.IndexByChannel;
import org.anchoranalysis.mpp.mark.voxelized.BufferArrayList;

class AddVoxelsToHistogram {
    public static void addVoxels(byte membership, List<RegionMembershipWithFlags> listRegionMembership, IndexByChannel<Histogram> partitionList, BufferArrayList bufferArrList, int globalOffset, int zLocal) {
        AddVoxelsToHistogram.iterateRegions(membership, listRegionMembership, r -> AddVoxelsToHistogram.addRegionToPartition(partitionList, bufferArrList, globalOffset, r, zLocal));
    }

    private static void addRegionToPartition(IndexByChannel<Histogram> partitionList, BufferArrayList bufferArrList, int globalOffset, int r, int zLocal) {
        for (int i = 0; i < partitionList.size(); ++i) {
            partitionList.get(i).addToVoxelList(r, zLocal, bufferArrList.get(i).getUnsigned(globalOffset));
        }
    }

    private static void iterateRegions(byte membership, List<RegionMembershipWithFlags> listRegionMembership, IntConsumer func) {
        for (int r = 0; r < listRegionMembership.size(); ++r) {
            RegionMembershipWithFlags rm = listRegionMembership.get(r);
            if (!rm.isMemberFlag(membership)) continue;
            func.accept(r);
        }
    }

    @Generated
    private AddVoxelsToHistogram() {
    }
}

