/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.points.DistanceCalculatorToLine;
import org.anchoranalysis.mpp.mark.points.PointListBase;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class PolygonCurve
extends PointListBase {
    private static final long serialVersionUID = -2043844259526872933L;
    private static final byte FLAG_SUBMARK_NONE = RegionMembershipUtilities.flagForNoRegion();
    private static final byte FLAG_SUBMARK_INSIDE = RegionMembershipUtilities.flagForRegion(0);
    private static final double DISTANCE_THRESHOLD = 0.7;
    private transient DistanceCalculatorToLine distanceCalculator = new DistanceCalculatorToLine();

    @Override
    public byte isPointInside(Point3i point) {
        if (this.distanceToPolygonLocal(point) < 0.7) {
            return FLAG_SUBMARK_INSIDE;
        }
        return FLAG_SUBMARK_NONE;
    }

    private double distanceToPolygonSegmentLocal(Point3i point, Point3d pointFirst, Point3d pointSecond) {
        if ((double)point.x() < pointFirst.x() - 0.7) {
            return Double.POSITIVE_INFINITY;
        }
        if ((double)point.y() < pointFirst.y() - 0.7) {
            return Double.POSITIVE_INFINITY;
        }
        if ((double)point.z() < pointFirst.z() - 0.7) {
            return Double.POSITIVE_INFINITY;
        }
        if ((double)point.x() > pointSecond.x() + 0.7) {
            return Double.POSITIVE_INFINITY;
        }
        if ((double)point.y() > pointSecond.y() + 0.7) {
            return Double.POSITIVE_INFINITY;
        }
        if ((double)point.z() > pointSecond.z() + 0.7) {
            return Double.POSITIVE_INFINITY;
        }
        this.distanceCalculator.setPoints(pointFirst, pointSecond);
        return this.distanceCalculator.distanceToLine(point);
    }

    private double distanceToPolygonLocal(Point3i point) {
        double min = Double.POSITIVE_INFINITY;
        int numPtsMinus1 = this.getPoints().size() - 1;
        for (int i = 0; i < numPtsMinus1; ++i) {
            Point3d pointFirst = this.getPoints().get(i);
            Point3d pointSecond = this.getPoints().get(i + 1);
            double distance = this.distanceToPolygonSegmentLocal(point, pointFirst, pointSecond);
            min = Math.min(min, distance);
        }
        return min;
    }

    @Override
    public Mark duplicate() {
        PolygonCurve out = new PolygonCurve();
        this.doDuplicate(out);
        return out;
    }

    @Override
    public double volume(int regionID) {
        return this.getPoints().size();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void scale(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        throw new CheckedUnsupportedOperationException();
    }

    @Override
    public int numberDimensions() {
        return 2;
    }

    @Override
    public Point3d centerPoint() {
        return this.box().midpoint();
    }

    @Override
    public String getName() {
        return "markPolygonCurve";
    }

    @Override
    public int numberRegions() {
        return 1;
    }

    @Override
    public BoundingBox boxAllRegions(Dimensions dimensions) {
        return this.box(dimensions, 0);
    }
}

