/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import com.google.common.base.Preconditions;
import ij.gui.PolygonRoi;
import java.util.List;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.points.PointListBase;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class Polygon
extends PointListBase {
    private static final long serialVersionUID = 1718294470056379145L;
    private static final byte FLAG_OUTSIDE = RegionMembershipUtilities.flagForNoRegion();
    private static final byte FLAG_SUBMARK_INSIDE = RegionMembershipUtilities.flagForRegion(0);
    private PolygonRoi region;
    private double area;
    private Point3d centroid;

    @Override
    public byte isPointInside(Point3i point) {
        Point3d pointDouble = PointConverter.doubleFromInt((ReadableTuple3i)point);
        if (this.containsPixel(point.x(), point.y()) || this.getPoints().contains(pointDouble)) {
            return FLAG_SUBMARK_INSIDE;
        }
        return FLAG_OUTSIDE;
    }

    private boolean containsPixel(double x, double y) {
        int xInt = (int)x;
        int yInt = (int)y;
        return this.contains(xInt, yInt) || this.contains(xInt, yInt + 1) || this.contains(xInt + 1, yInt) || this.contains(xInt + 1, yInt + 1);
    }

    private boolean contains(int x, int y) {
        return this.region.contains(x, y);
    }

    @Override
    public Mark duplicate() {
        Polygon out = new Polygon();
        this.doDuplicate(out);
        return out;
    }

    @Override
    public double volume(int regionID) {
        return this.area;
    }

    public String toString() {
        return "polygon";
    }

    @Override
    public void scale(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        throw new CheckedUnsupportedOperationException();
    }

    @Override
    public int numberDimensions() {
        return 2;
    }

    @Override
    public Point3d centerPoint() {
        return this.centroid;
    }

    @Override
    public String getName() {
        return "polygon";
    }

    @Override
    public void updateAfterPointsChange() {
        super.updateAfterPointsChange();
        Preconditions.checkArgument((!this.getPoints().isEmpty() ? 1 : 0) != 0);
        this.area = Polygon.area(this.getPoints());
        this.centroid = Polygon.centroid(this.getPoints(), this.area);
        this.region = Polygon.createRoi(this.getPoints());
    }

    private static PolygonRoi createRoi(List<Point3d> points) {
        float[] xArr = new float[points.size()];
        float[] yArr = new float[points.size()];
        int i = 0;
        for (Point3d point : points) {
            xArr[i] = (float)point.x();
            yArr[i] = (float)point.y();
            ++i;
        }
        return new PolygonRoi(xArr, yArr, points.size(), 2);
    }

    private static double area(List<Point3d> points) {
        int numPoints = points.size();
        double sum = 0.0;
        for (int i = 0; i < numPoints; ++i) {
            Point3d point = points.get(i);
            Point3d pointNext = i == numPoints - 1 ? points.get(0) : points.get(i + 1);
            sum += point.x() * pointNext.y() - pointNext.x() * point.y();
        }
        return sum / 2.0;
    }

    private static Point3d centroid(List<Point3d> points, double area) {
        int numPoints = points.size();
        Point3d centroid = new Point3d();
        for (int i = 0; i < numPoints; ++i) {
            Point3d point = points.get(i);
            Point3d pointNext = i == numPoints - 1 ? points.get(0) : points.get(i + 1);
            double leftX = point.x() + pointNext.x();
            double leftY = point.y() + pointNext.y();
            double right = point.x() * pointNext.y() - pointNext.x() * point.y();
            centroid.setX(centroid.x() + leftX * right);
            centroid.setY(centroid.y() + leftY * right);
        }
        centroid.scale(1.0 / (6.0 * area));
        return centroid;
    }

    @Override
    public int numberRegions() {
        return 1;
    }

    @Override
    public BoundingBox boxAllRegions(Dimensions dimensions) {
        return this.box(dimensions, 0);
    }
}

