/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.points;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.points.PointListBase;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class PointList
extends PointListBase {
    private static final long serialVersionUID = 1718294470056379145L;
    private static final byte FLAG_SUBMARK_NONE = RegionMembershipUtilities.flagForNoRegion();
    private static final byte FLAG_SUBMARK_INSIDE = RegionMembershipUtilities.flagForRegion(0);
    private Set<Point3d> set;

    public PointList() {
    }

    public PointList(Stream<Point3d> stream) {
        super(stream);
    }

    @Override
    public byte isPointInside(Point3i pointIsInside) {
        if (this.set.contains(PointConverter.doubleFromInt((ReadableTuple3i)pointIsInside))) {
            return FLAG_SUBMARK_INSIDE;
        }
        return FLAG_SUBMARK_NONE;
    }

    @Override
    public void updateAfterPointsChange() {
        super.updateAfterPointsChange();
        this.set = new HashSet<Point3d>(this.getPoints());
    }

    @Override
    public Mark duplicate() {
        PointList out = new PointList();
        this.doDuplicate(out);
        return out;
    }

    @Override
    public double volume(int regionID) {
        return this.getPoints().size();
    }

    public String toString() {
        return PointList.class.getSimpleName() + "_" + this.hashCode();
    }

    @Override
    public void scale(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        for (int i = 0; i < this.getPoints().size(); ++i) {
            Point3d point = this.getPoints().get(i);
            scaleFactor.scale(point);
        }
    }

    @Override
    public int numberDimensions() {
        return 2;
    }

    @Override
    public String getName() {
        return PointList.class.getSimpleName();
    }

    @Override
    public Point3d centerPoint() {
        return this.box().midpoint();
    }

    @Override
    public int numberRegions() {
        return 1;
    }

    @Override
    public BoundingBox boxAllRegions(Dimensions dimensions) {
        return this.box(dimensions, 0);
    }
}

