/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.conic;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.QuickOverlapCalculation;
import org.anchoranalysis.mpp.mark.conic.BoundingBoxCalculator;
import org.anchoranalysis.mpp.mark.conic.ConicBase;
import org.anchoranalysis.mpp.mark.conic.EllipsoidMatrixCalculator;
import org.anchoranalysis.mpp.mark.conic.EllipsoidUtilities;
import org.anchoranalysis.mpp.mark.conic.ScaleChecker;
import org.anchoranalysis.mpp.mark.conic.TensorUtilities;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.Orientation3DEulerAngles;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.Tuple3d;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class Ellipsoid
extends ConicBase
implements Serializable {
    private static final long serialVersionUID = -2678275834893266874L;
    private static final int NUM_DIM = 3;
    private static final byte FLAG_SUBMARK_NONE = RegionMembershipUtilities.flagForNoRegion();
    private static final byte FLAG_SUBMARK_REGION0 = RegionMembershipUtilities.flagForRegion(0, 2, 4);
    private static final byte FLAG_SUBMARK_REGION1 = RegionMembershipUtilities.flagForRegion(0, 2);
    private static final byte FLAG_SUBMARK_REGION2 = RegionMembershipUtilities.flagForRegion(0, 1);
    private static final byte FLAG_SUBMARK_REGION3 = RegionMembershipUtilities.flagForRegion(1, 5);
    private static final byte FLAG_SUBMARK_REGION4 = RegionMembershipUtilities.flagForRegion(3);
    private double shell = 0.1;
    private double innerCoreDistance = 0.4;
    private Point3d radii;
    private Orientation orientation = new Orientation3DEulerAngles(0.0, 0.0, 0.0);
    private EllipsoidMatrixCalculator ellipsoidCalculator;
    private double shellInnerCore;
    private double shellInternal;
    private double shellExternal;
    private double shellExternalOut;
    private double shellInnerCoreSquared;
    private double shellInternalSquared;
    private double shellExternalSquared;
    private double shellExternalOutSquared;
    private double radiiShellMaxSq;
    private transient QuickOverlapCalculation quickOverlap = (mark, regionID) -> {
        if (!(mark instanceof Ellipsoid)) {
            return false;
        }
        Ellipsoid target = (Ellipsoid)mark;
        DoubleMatrix1D relativePosition = TensorUtilities.threeElementMatrix(target.getPosition().x() - this.getPosition().x(), target.getPosition().y() - this.getPosition().y(), target.getPosition().z() - this.getPosition().z());
        DoubleMatrix1D relativePositionSquared = relativePosition.copy();
        relativePositionSquared.assign(Functions.square);
        double distance = relativePositionSquared.zSum();
        return distance > Math.pow(this.getMaximumRadius(regionID) + target.getMaximumRadius(regionID), 2.0);
    };

    public Ellipsoid() {
        this.radii = new Point3d();
        this.ellipsoidCalculator = new EllipsoidMatrixCalculator(3);
    }

    public Ellipsoid(Ellipsoid src) {
        super(src);
        this.radii = new Point3d((Tuple3d)src.radii);
        this.shell = src.shell;
        this.innerCoreDistance = src.innerCoreDistance;
        this.ellipsoidCalculator = new EllipsoidMatrixCalculator(src.ellipsoidCalculator);
        this.orientation = src.orientation;
        this.radiiShellMaxSq = src.radiiShellMaxSq;
        this.shellExternal = src.shellExternal;
        this.shellExternalOut = src.shellExternalOut;
        this.shellInternal = src.shellInternal;
        this.shellInnerCore = src.shellInnerCore;
        this.shellExternalSquared = src.shellExternalSquared;
        this.shellExternalOutSquared = src.shellExternalOutSquared;
        this.shellInternalSquared = src.shellInternalSquared;
        this.shellInnerCoreSquared = src.shellInnerCoreSquared;
    }

    @Override
    public String getName() {
        return "ellipsoid";
    }

    public static double getEllipsoidSum(double x, double y, double z, DoubleMatrix2D mat) {
        return x * (x * mat.get(0, 0) + y * mat.get(1, 0) + z * mat.get(2, 0)) + y * (x * mat.get(0, 1) + y * mat.get(1, 1) + z * mat.get(2, 1)) + z * (x * mat.get(0, 2) + y * mat.get(1, 2) + z * mat.get(2, 2));
    }

    private static double l2norm(double x, double y, double z) {
        return Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0);
    }

    @Override
    public final byte isPointInside(Point3i point) {
        double z;
        double y;
        double x = (double)point.x() - this.getPosition().x() + 0.5;
        if (Ellipsoid.l2norm(x, y = (double)point.y() - this.getPosition().y() + 0.5, z = (double)point.z() - this.getPosition().z() + 0.5) > this.radiiShellMaxSq) {
            return FLAG_SUBMARK_NONE;
        }
        double sum = Ellipsoid.getEllipsoidSum(x, y, z, this.ellipsoidCalculator.getEllipsoidMatrix());
        if (sum <= this.shellInnerCoreSquared) {
            return FLAG_SUBMARK_REGION0;
        }
        sum = Ellipsoid.getEllipsoidSum(x, y, z, this.ellipsoidCalculator.getEllipsoidMatrix());
        if (sum <= this.shellInternalSquared) {
            return FLAG_SUBMARK_REGION1;
        }
        if (sum <= 1.0) {
            return FLAG_SUBMARK_REGION2;
        }
        if (sum <= this.shellExternalSquared) {
            return FLAG_SUBMARK_REGION3;
        }
        if (sum <= this.shellExternalOutSquared) {
            return FLAG_SUBMARK_REGION4;
        }
        return FLAG_SUBMARK_NONE;
    }

    @Override
    public Mark duplicate() {
        return new Ellipsoid(this);
    }

    public String toString() {
        return String.format("%s %s pos=%s %s vol=%e", "Ellpsd", this.identifier(), this.positionString(), this.strMarks(), this.volume(0));
    }

    @Override
    public double volume(int regionID) {
        return switch (regionID) {
            case 0 -> this.volumeForShell(1.0);
            case 5 -> this.volumeForShell(this.shellExternal) - this.volumeForShell(1.0);
            case 1 -> this.volumeForShell(this.shellExternal) - this.volumeForShell(this.shellInternal);
            case 2 -> this.volumeForShell(this.shellInternal);
            case 3 -> this.volumeForShell(this.shellExternalOut) - this.volumeForShell(this.shellExternal);
            case 4 -> this.volumeForShell(this.shellInnerCore);
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected regionID");
                }
                yield 0.0;
            }
        };
    }

    private double volumeForShell(double multiplier) {
        return Math.PI * 4 * this.radii.x() * this.radii.y() * this.radii.z() * Math.pow(multiplier, 3.0) / 3.0;
    }

    public void updateAfterMarkChange() {
        DoubleMatrix2D matRot = this.orientation.getRotationMatrix().getMatrix();
        double[] radiusArray = TensorUtilities.threeElementArray(this.radii.x(), this.radii.y(), this.radii.z());
        assert (matRot.rows() == 3);
        this.ellipsoidCalculator.update(radiusArray, matRot);
        this.shellInternal = 1.0 - this.shell;
        this.shellExternal = 1.0 + this.shell;
        this.shellExternalOut = 1.0 + this.shell * 2.0;
        this.shellInnerCore = 1.0 - this.innerCoreDistance;
        this.shellInternalSquared = TensorUtilities.squared(this.shellInternal);
        this.shellExternalSquared = TensorUtilities.squared(this.shellExternal);
        this.shellExternalOutSquared = TensorUtilities.squared(this.shellExternalOut);
        this.shellInnerCoreSquared = TensorUtilities.squared(this.shellInnerCore);
        this.radiiShellMaxSq = TensorUtilities.squared(this.ellipsoidCalculator.getMaximumRadius() * this.shellExternalOut);
        assert (this.shellInternal > 0.0);
    }

    @Override
    public BoundingBox box(Dimensions dimensions, int regionID) {
        DoubleMatrix1D s = this.ellipsoidCalculator.getBoundingBoxMatrix().copy();
        assert (this.shellInternal > 0.0);
        assert (this.shellInnerCore > 0.0);
        if (regionID == 1 || regionID == 5) {
            s.assign(Functions.mult((double)this.shellExternal));
        } else if (regionID == 2) {
            s.assign(Functions.mult((double)this.shellInternal));
        } else if (regionID == 3) {
            s.assign(Functions.mult((double)this.shellExternalOut));
        } else if (regionID == 4) {
            s.assign(Functions.mult((double)this.shellInnerCore));
        }
        return BoundingBoxCalculator.boxFromBounds(this.getPosition(), s, true, dimensions);
    }

    private String strMarks() {
        return String.format("rad=[%3.3f, %3.3f, %3.3f] rot=[%s] shell=[%f]", this.radii.x(), this.radii.y(), this.radii.z(), this.orientation.toString(), this.shell);
    }

    @Override
    public Optional<QuickOverlapCalculation> quickOverlap() {
        return Optional.of(this.quickOverlap);
    }

    @Override
    public void setMarksExplicit(Point3d pos, Orientation orientation, Point3d radii) {
        super.setPosition(pos);
        this.orientation = orientation;
        this.radii = radii;
        this.updateAfterMarkChange();
        assert (this.shellInternal > 0.0);
    }

    @Override
    public void setMarksExplicit(Point3d position) {
        super.setPosition(position);
        this.updateAfterMarkChange();
    }

    @Override
    public double[] createRadiiArray() {
        return TensorUtilities.threeElementArray(this.radii.x(), this.radii.y(), this.radii.z());
    }

    @Override
    public double[] createRadiiArrayResolved(Optional<Resolution> resolution) {
        return EllipsoidUtilities.normalisedRadii(this, resolution);
    }

    @Override
    public void scale(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        super.scale(scaleFactor);
        ScaleChecker.checkIdenticalXY(scaleFactor);
        this.radii.setX(this.radii.x() * scaleFactor.x());
        this.radii.setY(this.radii.y() * scaleFactor.x());
        this.radii.setZ(this.radii.z() * scaleFactor.x());
        this.updateAfterMarkChange();
    }

    @Override
    public boolean equalsDeep(Mark m) {
        if (!super.equalsDeep(m)) {
            return false;
        }
        if (!(m instanceof Ellipsoid)) {
            return false;
        }
        Ellipsoid trgt = (Ellipsoid)m;
        if (!this.radii.equals((Object)trgt.radii)) {
            return false;
        }
        return this.orientation.equals((Object)trgt.orientation);
    }

    @Override
    public int numberDimensions() {
        return 3;
    }

    @Override
    public void setMarksExplicit(Point3d position, Orientation orientation) {
        this.setMarksExplicit(position, orientation, this.radii);
    }

    @Override
    public int numberRegions() {
        return 5;
    }

    @Override
    public BoundingBox boxAllRegions(Dimensions dimensions) {
        return this.box(dimensions, 3);
    }

    private double getMaximumRadius(int regionID) {
        double maxRadius = this.ellipsoidCalculator.getMaximumRadius();
        if (regionID == 1) {
            maxRadius *= 1.0 + this.shell;
        }
        return maxRadius;
    }

    @Generated
    public double getShell() {
        return this.shell;
    }

    @Generated
    public void setShell(double shell) {
        this.shell = shell;
    }

    @Generated
    public double getInnerCoreDistance() {
        return this.innerCoreDistance;
    }

    @Generated
    public void setInnerCoreDistance(double innerCoreDistance) {
        this.innerCoreDistance = innerCoreDistance;
    }

    @Generated
    public Point3d getRadii() {
        return this.radii;
    }

    @Generated
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Generated
    public EllipsoidMatrixCalculator getEllipsoidCalculator() {
        return this.ellipsoidCalculator;
    }
}

