/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.conic;

import cern.colt.matrix.DoubleMatrix1D;
import lombok.Generated;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.mark.PointClamper;
import org.anchoranalysis.mpp.mark.conic.TensorUtilities;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class BoundingBoxCalculator {
    public static BoundingBox boxFromBounds(Point3d pos, double radius, boolean do3D, Dimensions dimensions) {
        DoubleMatrix1D radiiBoundingBoxes = TensorUtilities.threeElementMatrix(radius, radius, radius);
        return BoundingBoxCalculator.boxFromBounds(pos, radiiBoundingBoxes, do3D, dimensions);
    }

    public static BoundingBox boxFromBounds(Point3d center, DoubleMatrix1D radiiMatrix, boolean do3D, Dimensions dimensions) {
        Point3i min = BoundingBoxCalculator.subTwoPointsClamp(center, radiiMatrix, do3D, dimensions);
        Point3i max = BoundingBoxCalculator.addTwoPointsClamp(center, radiiMatrix, do3D, dimensions);
        assert (max.x() >= min.x());
        assert (max.y() >= min.y());
        assert (max.z() >= min.z());
        return BoundingBox.createReuse((ReadableTuple3i)min, (ReadableTuple3i)max);
    }

    private static Point3i subTwoPointsClamp(Point3d point1, DoubleMatrix1D point2, boolean do3D, Dimensions dimensions) {
        Point3i point = BoundingBoxCalculator.subTwoPoints(point1, point2, do3D);
        return PointClamper.clamp(point, dimensions);
    }

    private static Point3i addTwoPointsClamp(Point3d point1, DoubleMatrix1D point2, boolean do3D, Dimensions dimensions) {
        Point3i point = BoundingBoxCalculator.addTwoPoints(point1, point2, do3D);
        return PointClamper.clamp(point, dimensions);
    }

    private static Point3i subTwoPoints(Point3d point1, DoubleMatrix1D point2, boolean do3D) {
        return new Point3i(BoundingBoxCalculator.floorDiff(point1.x(), point2.get(0)), BoundingBoxCalculator.floorDiff(point1.y(), point2.get(1)), do3D ? BoundingBoxCalculator.floorDiff(point1.z(), point2.get(2)) : 0);
    }

    private static Point3i addTwoPoints(Point3d point1, DoubleMatrix1D point2, boolean do3D) {
        return new Point3i(BoundingBoxCalculator.ceilSum(point1.x(), point2.get(0)), BoundingBoxCalculator.ceilSum(point1.y(), point2.get(1)), do3D ? BoundingBoxCalculator.ceilSum(point1.z(), point2.get(2)) : 0);
    }

    private static int floorDiff(double x, double y) {
        return (int)Math.floor(x - y);
    }

    private static int ceilSum(double x, double y) {
        return (int)Math.ceil(x + y);
    }

    @Generated
    private BoundingBoxCalculator() {
    }
}

