/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.bean.bound;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.mpp.bean.bound.Bound;
import org.anchoranalysis.mpp.bean.bound.BoundMinMax;

public class BoundPhysicalExtent
extends BoundMinMax {
    private static final long serialVersionUID = -5440824428055546445L;

    public BoundPhysicalExtent(double min, double max) {
        super(min, max);
    }

    public BoundPhysicalExtent(BoundPhysicalExtent source) {
        super(source);
    }

    @Override
    public double getMinResolved(Optional<Resolution> resolution, boolean do3D) {
        return BoundPhysicalExtent.maybeDivideBy(this.getMin(), resolution, do3D);
    }

    @Override
    public double getMaxResolved(Optional<Resolution> resolution, boolean do3D) {
        return BoundPhysicalExtent.maybeDivideBy(this.getMax(), resolution, do3D);
    }

    @Override
    public Bound duplicate() {
        return new BoundPhysicalExtent(this);
    }

    private static double maybeDivideBy(double value, Optional<Resolution> resolution, boolean do3D) {
        if (resolution.isPresent()) {
            return value / BoundPhysicalExtent.minResolutionComponent(resolution.get(), do3D);
        }
        return value;
    }

    private static double minResolutionComponent(Resolution resolution, boolean do3D) {
        double min2D = Math.min(resolution.x(), resolution.y());
        if (do3D) {
            return Math.min(min2D, resolution.z());
        }
        return min2D;
    }

    @Generated
    public BoundPhysicalExtent() {
    }
}

