/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.io.input;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.StoreSupplier;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.mpp.io.input.MultiInputSubMap;
import org.anchoranalysis.mpp.io.input.OperationMap;

public class StackWithMap
implements MultiInputSubMap<TimeSeries> {
    private final String mainObjectName;
    private final ProvidesStackInput mainInputObject;
    private OperationMap<TimeSeries> map = new OperationMap();

    @Override
    public void addToStore(NamedProviderStore<TimeSeries> stackCollection, Logger logger) throws OperationFailedException {
        this.addToStore(stackCollection, 0, logger);
    }

    public void addToStore(NamedProviderStore<TimeSeries> stackCollection, int seriesNum, Logger logger) throws OperationFailedException {
        this.mainInputObject.addToStoreWithName(this.mainObjectName, stackCollection, seriesNum, logger);
        this.map.addToStore(stackCollection, logger);
    }

    @Override
    public void add(String name, StoreSupplier<TimeSeries> op) {
        this.map.add(name, op);
    }

    public void close(ErrorReporter errorReporter) {
        this.mainInputObject.close(errorReporter);
        this.map = null;
    }

    public String getMainObjectName() {
        return this.mainObjectName;
    }

    public String inputName() {
        return this.mainInputObject.identifier();
    }

    public Optional<Path> pathForBinding() {
        return this.mainInputObject.pathForBinding();
    }

    public int numFrames() throws OperationFailedException {
        return this.mainInputObject.numberFrames();
    }

    @Override
    public StoreSupplier<TimeSeries> get(String name) throws OperationFailedException {
        if (name.equals(this.mainObjectName)) {
            throw new OperationFailedException("Retrieving the main-object name is not allowed");
        }
        return this.map.get(name);
    }

    @Generated
    public StackWithMap(String mainObjectName, ProvidesStackInput mainInputObject) {
        this.mainObjectName = mainObjectName;
        this.mainInputObject = mainInputObject;
    }
}

