/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.io.input;

import java.util.HashMap;
import java.util.Map;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.StoreSupplier;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.mpp.io.input.MultiInputSubMap;

public class OperationMap<T>
implements MultiInputSubMap<T> {
    private Map<String, StoreSupplier<T>> map = new HashMap<String, StoreSupplier<T>>();

    @Override
    public void add(String name, StoreSupplier<T> op) {
        this.map.put(name, op);
    }

    @Override
    public void addToStore(NamedProviderStore<T> namedStore, Logger logger) throws OperationFailedException {
        for (Map.Entry<String, StoreSupplier<T>> entry : this.map.entrySet()) {
            namedStore.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public StoreSupplier<T> get(String name) throws OperationFailedException {
        StoreSupplier<T> ret = this.map.get(name);
        if (ret == null) {
            throw new OperationFailedException(String.format("Cannot find key '%s'", name));
        }
        return ret;
    }

    public Map<String, StoreSupplier<T>> getMap() {
        return this.map;
    }
}

