/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.io.bean.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.image.io.bean.stack.reader.InputManagerWithStackReader;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.bean.InputManager;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.mpp.io.bean.input.AppendHelper;
import org.anchoranalysis.mpp.io.input.MultiInput;

public class MultiInputManager
extends InputManagerWithStackReader<MultiInput> {
    @BeanField
    private String inputName = "input_image";
    @BeanField
    private InputManager<? extends ProvidesStackInput> input;
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendStack = Arrays.asList(new NamedBean[0]);
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendMarks = Arrays.asList(new NamedBean[0]);
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendMarksFromAnnotation = new ArrayList<NamedBean<DerivePath>>();
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendMarksFromAnnotationAcceptedOnly = new ArrayList<NamedBean<DerivePath>>();
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendMarksFromAnnotationRejectedOnly = new ArrayList<NamedBean<DerivePath>>();
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendObjects = new ArrayList<NamedBean<DerivePath>>();
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendDictionary = new ArrayList<NamedBean<DerivePath>>();
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendHistogram = new ArrayList<NamedBean<DerivePath>>();
    @BeanField
    @OptionalBean
    private List<NamedBean<DerivePath>> appendFilePath = new ArrayList<NamedBean<DerivePath>>();

    public MultiInputManager(String inputName, InputManager<? extends ProvidesStackInput> input) {
        this.inputName = inputName;
        this.input = input;
    }

    public InputsWithDirectory<MultiInput> inputs(InputManagerParameters parameters) throws InputReadFailedException {
        return this.input.inputs(parameters).map(mainStack -> {
            MultiInput inputToAdd = new MultiInput(this.inputName, (ProvidesStackInput)mainStack);
            this.appendFromLists(new AppendHelper(inputToAdd, parameters.isDebugModeActivated(), parameters.getOperationContext()));
            return inputToAdd;
        });
    }

    private void appendFromLists(AppendHelper helper) {
        helper.appendStack(this.appendStack, this.getStackReader());
        this.appendFromVariousMarksSources(helper);
        helper.appendObjects(this.appendObjects);
        helper.appendDictionary(this.appendDictionary);
        helper.appendHistogram(this.appendHistogram);
        helper.appendFilePath(this.appendFilePath);
    }

    private void appendFromVariousMarksSources(AppendHelper helper) {
        helper.appendMarks(this.appendMarks);
        helper.appendMarksFromAnnotation(this.appendMarksFromAnnotation, true, true);
        helper.appendMarksFromAnnotation(this.appendMarksFromAnnotationAcceptedOnly, true, false);
        helper.appendMarksFromAnnotation(this.appendMarksFromAnnotationRejectedOnly, false, true);
    }

    @Generated
    public MultiInputManager() {
    }

    @Generated
    public String getInputName() {
        return this.inputName;
    }

    @Generated
    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    @Generated
    public InputManager<? extends ProvidesStackInput> getInput() {
        return this.input;
    }

    @Generated
    public void setInput(InputManager<? extends ProvidesStackInput> input) {
        this.input = input;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendStack() {
        return this.appendStack;
    }

    @Generated
    public void setAppendStack(List<NamedBean<DerivePath>> appendStack) {
        this.appendStack = appendStack;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendMarks() {
        return this.appendMarks;
    }

    @Generated
    public void setAppendMarks(List<NamedBean<DerivePath>> appendMarks) {
        this.appendMarks = appendMarks;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendMarksFromAnnotation() {
        return this.appendMarksFromAnnotation;
    }

    @Generated
    public void setAppendMarksFromAnnotation(List<NamedBean<DerivePath>> appendMarksFromAnnotation) {
        this.appendMarksFromAnnotation = appendMarksFromAnnotation;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendMarksFromAnnotationAcceptedOnly() {
        return this.appendMarksFromAnnotationAcceptedOnly;
    }

    @Generated
    public void setAppendMarksFromAnnotationAcceptedOnly(List<NamedBean<DerivePath>> appendMarksFromAnnotationAcceptedOnly) {
        this.appendMarksFromAnnotationAcceptedOnly = appendMarksFromAnnotationAcceptedOnly;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendMarksFromAnnotationRejectedOnly() {
        return this.appendMarksFromAnnotationRejectedOnly;
    }

    @Generated
    public void setAppendMarksFromAnnotationRejectedOnly(List<NamedBean<DerivePath>> appendMarksFromAnnotationRejectedOnly) {
        this.appendMarksFromAnnotationRejectedOnly = appendMarksFromAnnotationRejectedOnly;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendObjects() {
        return this.appendObjects;
    }

    @Generated
    public void setAppendObjects(List<NamedBean<DerivePath>> appendObjects) {
        this.appendObjects = appendObjects;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendDictionary() {
        return this.appendDictionary;
    }

    @Generated
    public void setAppendDictionary(List<NamedBean<DerivePath>> appendDictionary) {
        this.appendDictionary = appendDictionary;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendHistogram() {
        return this.appendHistogram;
    }

    @Generated
    public void setAppendHistogram(List<NamedBean<DerivePath>> appendHistogram) {
        this.appendHistogram = appendHistogram;
    }

    @Generated
    public List<NamedBean<DerivePath>> getAppendFilePath() {
        return this.appendFilePath;
    }

    @Generated
    public void setAppendFilePath(List<NamedBean<DerivePath>> appendFilePath) {
        this.appendFilePath = appendFilePath;
    }
}

