/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.io.bean.input;

import java.nio.file.Path;
import org.anchoranalysis.annotation.mark.DualMarksAnnotation;
import org.anchoranalysis.core.serialize.DeserializationFailedException;
import org.anchoranalysis.core.serialize.XStreamDeserializer;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.mpp.mark.MarkCollection;

class DeserializerHelper<T> {
    private XStreamDeserializer<MarkCollection> deserializerMarks = new XStreamDeserializer();
    private XStreamDeserializer<DualMarksAnnotation<T>> deserializerAnnotation = new XStreamDeserializer();

    DeserializerHelper() {
    }

    public MarkCollection deserializeMarks(Path path, OperationContext context) throws DeserializationFailedException {
        return (MarkCollection)this.deserializerMarks.deserialize(path, context);
    }

    public MarkCollection deserializeMarksFromAnnotation(Path outPath, boolean includeAccepted, boolean includeRejected, OperationContext context) throws DeserializationFailedException {
        DualMarksAnnotation ann = (DualMarksAnnotation)this.deserializerAnnotation.deserialize(outPath, context);
        if (!ann.isFinished()) {
            throw new DeserializationFailedException("Annotation was never finished");
        }
        if (!ann.isAccepted()) {
            throw new DeserializationFailedException("Annotation was never accepted");
        }
        MarkCollection marksOut = new MarkCollection();
        if (includeAccepted) {
            marksOut.addAll(ann.marks());
        }
        if (includeRejected && ann.getMarksReject() != null) {
            marksOut.addAll(ann.getMarksReject());
        }
        return marksOut;
    }
}

