/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.io.bean.input;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.histogram.input.HistogramCSVReader;
import org.anchoranalysis.image.io.object.input.ObjectCollectionReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.mpp.io.bean.input.DeserializerHelper;
import org.anchoranalysis.mpp.io.input.MultiInput;
import org.anchoranalysis.mpp.io.input.MultiInputSubMap;

class AppendHelper {
    private static final DeserializerHelper<?> DESERIALIZER = new DeserializerHelper();
    private final MultiInput input;
    private final boolean debugMode;
    private final OperationContext context;

    public void appendStack(List<NamedBean<DerivePath>> paths, StackReader stackReader) {
        this.append(paths, MultiInput::stack, outPath -> {
            try {
                return this.openRaster(outPath, stackReader);
            }
            catch (ImageIOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        });
    }

    public void appendHistogram(List<NamedBean<DerivePath>> paths) {
        this.append(paths, MultiInput::histogram, HistogramCSVReader::readHistogramFromFile);
    }

    public void appendFilePath(List<NamedBean<DerivePath>> paths) {
        this.append(paths, MultiInput::filePath, outPath -> outPath);
    }

    public void appendDictionary(List<NamedBean<DerivePath>> paths) {
        this.append(paths, MultiInput::dictionary, Dictionary::readFromFile);
    }

    public void appendMarks(List<NamedBean<DerivePath>> paths) {
        this.append(paths, MultiInput::marks, serialized -> DESERIALIZER.deserializeMarks(serialized, this.context));
    }

    public void appendMarksFromAnnotation(List<NamedBean<DerivePath>> paths, boolean includeAccepted, boolean includeRejected) {
        this.append(paths, MultiInput::marks, outPath -> DESERIALIZER.deserializeMarksFromAnnotation(outPath, includeAccepted, includeRejected, this.context));
    }

    public void appendObjects(List<NamedBean<DerivePath>> paths) {
        this.append(paths, MultiInput::objects, path -> ObjectCollectionReader.createFromPath((Path)path, (OperationContext)this.context));
    }

    private <T> void append(List<NamedBean<DerivePath>> list, Function<MultiInput, MultiInputSubMap<T>> extractMap, ReadFromPath<T> reader) {
        for (NamedBean<DerivePath> namedBean : list) {
            MultiInputSubMap<T> map = extractMap.apply(this.input);
            map.add(namedBean.getName(), () -> AppendHelper.readObjectForAppend(this.input, reader, namedBean, this.debugMode));
        }
    }

    private static <T> T readObjectForAppend(MultiInput input, ReadFromPath<T> reader, NamedBean<DerivePath> namedBean, boolean debugMode) throws OperationFailedException {
        try {
            return reader.apply(((DerivePath)namedBean.getValue()).deriveFrom(input::pathForBinding, debugMode).toAbsolutePath().normalize());
        }
        catch (Exception e) {
            throw new OperationFailedException("An error occured appending to the multi-input", (Throwable)e);
        }
    }

    private TimeSeries openRaster(Path path, StackReader stackReader) throws ImageIOException {
        try (OpenedImageFile openedFile = stackReader.openFile(path, this.context.getExecutionTimeRecorder());){
            TimeSeries timeSeries = openedFile.open(this.context.getLogger());
            return timeSeries;
        }
    }

    @Generated
    public AppendHelper(MultiInput input, boolean debugMode, OperationContext context) {
        this.input = input;
        this.debugMode = debugMode;
        this.context = context;
    }

    @FunctionalInterface
    private static interface ReadFromPath<T> {
        public T apply(Path var1) throws Exception;
    }
}

