/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.io.output;

import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.io.channel.output.ChannelGenerator;
import org.anchoranalysis.io.generator.Generator;
import org.anchoranalysis.io.generator.sequence.OutputSequenceFactory;
import org.anchoranalysis.io.generator.sequence.pattern.OutputPatternIntegerSuffix;
import org.anchoranalysis.io.generator.serialized.DictionaryGenerator;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.Outputter;

public class EnergyStackWriter {
    public static final String OUTPUT_ENERGY_STACK_DIRECTORY = "energyStack";
    private static final String OUTPUT_ENERGY_STACK_DICTIONARY = "energyStackDictionary";
    private final EnergyStack energyStack;
    private final Outputter outputter;

    public void writeEnergyStack() throws OutputWriteFailedException {
        OutputPatternIntegerSuffix directory = new OutputPatternIntegerSuffix(OUTPUT_ENERGY_STACK_DIRECTORY, OUTPUT_ENERGY_STACK_DIRECTORY, 2, true);
        this.createSequenceFactory().incrementingByOneStream(directory, this.energyStack.withoutParameters().asStack().asListChannels().stream());
        if (this.energyStack.getParameters() != null) {
            this.outputter.writerSelective().write(OUTPUT_ENERGY_STACK_DICTIONARY, DictionaryGenerator::new, () -> ((EnergyStack)this.energyStack).getParameters());
        }
    }

    private OutputSequenceFactory<Channel> createSequenceFactory() {
        ChannelGenerator generator = new ChannelGenerator();
        return new OutputSequenceFactory((Generator)generator, this.outputter.getChecked());
    }

    public EnergyStackWriter(EnergyStack energyStack, Outputter outputter) {
        this.energyStack = energyStack;
        this.outputter = outputter;
    }
}

