/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.io.input;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.image.io.stack.time.ExtractFrameStore;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.mpp.init.MarksInitialization;
import org.anchoranalysis.mpp.io.input.ExportSharedObjects;
import org.anchoranalysis.mpp.io.input.MultiInputSubMap;
import org.anchoranalysis.mpp.io.input.OperationMap;
import org.anchoranalysis.mpp.io.input.StackWithMap;
import org.anchoranalysis.mpp.mark.MarkCollection;

public class MultiInput
implements ProvidesStackInput,
ExportSharedObjects {
    public static final String DEFAULT_IMAGE_INPUT_NAME = "input_image";
    private StackWithMap stack;
    private OperationMap<MarkCollection> mapMarks = new OperationMap();
    private OperationMap<ObjectCollection> mapObjects = new OperationMap();
    private OperationMap<Dictionary> mapDictionary = new OperationMap();
    private OperationMap<Histogram> mapHistogram = new OperationMap();
    private OperationMap<Path> mapFilePath = new OperationMap();

    public MultiInput(ProvidesStackInput mainInputObject) {
        this(DEFAULT_IMAGE_INPUT_NAME, mainInputObject);
    }

    public MultiInput(String mainObjectName, ProvidesStackInput mainInputObject) {
        this.stack = new StackWithMap(mainObjectName, mainInputObject);
    }

    public void addToStoreInferNames(NamedProviderStore<TimeSeries> stacks, int seriesIndex, Logger logger) throws OperationFailedException {
        this.stack.addToStore(stacks, seriesIndex, logger);
    }

    public void addToStoreWithName(String name, NamedProviderStore<TimeSeries> stacks, int seriesIndex, Logger logger) throws OperationFailedException {
        throw new OperationFailedException("Not supported");
    }

    @Override
    public void copyTo(SharedObjects target, Logger logger) throws OperationFailedException {
        ImageInitialization image = new ImageInitialization(target);
        this.stack().addToStore((NamedProviderStore<TimeSeries>)new ExtractFrameStore(image.stacks()), logger);
        this.objects().addToStore((NamedProviderStore<ObjectCollection>)image.objects(), logger);
        this.dictionary().addToStore((NamedProviderStore<Dictionary>)image.dictionaries(), logger);
        this.filePath().addToStore((NamedProviderStore<Path>)image.filePaths(), logger);
        this.histogram().addToStore((NamedProviderStore<Histogram>)image.histograms(), logger);
        this.marks().addToStore((NamedProviderStore<MarkCollection>)new MarksInitialization(image).marks(), logger);
    }

    public String identifier() {
        return this.stack.inputName();
    }

    public Optional<Path> pathForBinding() {
        return this.stack.pathForBinding();
    }

    public void close(ErrorReporter errorReporter) {
        this.stack.close(errorReporter);
        this.mapMarks = null;
        this.mapObjects = null;
        this.mapDictionary = null;
        this.mapHistogram = null;
        this.mapFilePath = null;
    }

    public MultiInputSubMap<MarkCollection> marks() {
        return this.mapMarks;
    }

    public MultiInputSubMap<ObjectCollection> objects() {
        return this.mapObjects;
    }

    public MultiInputSubMap<Dictionary> dictionary() {
        return this.mapDictionary;
    }

    public MultiInputSubMap<Histogram> histogram() {
        return this.mapHistogram;
    }

    public MultiInputSubMap<Path> filePath() {
        return this.mapFilePath;
    }

    public MultiInputSubMap<TimeSeries> stack() {
        return this.stack;
    }

    public String getMainObjectName() {
        return this.stack.getMainObjectName();
    }

    public int numberFrames() throws OperationFailedException {
        return this.stack.numFrames();
    }
}

