/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.io.input;

import java.util.Optional;
import org.anchoranalysis.bean.define.Define;
import org.anchoranalysis.bean.initializable.property.BeanInitializer;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.experiment.io.InitializationContext;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.mpp.bean.MarksBean;
import org.anchoranalysis.mpp.init.MarksInitialization;
import org.anchoranalysis.mpp.io.input.ExportSharedObjects;

public class MarksInitializationFactory {
    public static MarksInitialization create(Optional<? extends ExportSharedObjects> input, InitializationContext context, Optional<Define> define) throws CreateException {
        SharedObjects sharedObjects = new SharedObjects(context.common());
        ImageInitialization image = new ImageInitialization(sharedObjects, context.getSuggestedSize());
        if (input.isPresent()) {
            try {
                input.get().copyTo(sharedObjects, context.getLogger());
            }
            catch (OperationFailedException e) {
                throw new CreateException((Throwable)e);
            }
        }
        MarksInitialization marks = new MarksInitialization(image);
        if (define.isPresent()) {
            try {
                BeanInitializer initializer = MarksBean.initializerForMarksBeans();
                initializer.setParam((Object)marks);
                marks.populate(initializer, define.get(), context.getLogger());
            }
            catch (OperationFailedException e) {
                throw new CreateException((Throwable)e);
            }
        }
        return marks;
    }

    public static MarksInitialization createFromExisting(InitializationContext context, Optional<Define> define, Optional<SharedObjects> sharedObjects, Optional<Dictionary> dictionary) throws CreateException {
        MarksInitialization marks = MarksInitializationFactory.create(Optional.empty(), context, define);
        try {
            marks.image().addSharedObjectsDictionary(sharedObjects, dictionary);
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
        return marks;
    }

    private MarksInitializationFactory() {
    }
}

