/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.writer;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.namestyle.IndexableOutputNameStyle;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.io.output.writer.ElementSupplier;
import org.anchoranalysis.io.output.writer.ElementWriterSupplier;
import org.anchoranalysis.io.output.writer.Writer;

public class WriterRouterErrors {
    private Writer delegate;
    private ErrorReporter errorReporter;

    public Optional<Outputter> createSubdirectory(String outputName, boolean inheritOutputRulesAndRecording) {
        try {
            return this.delegate.createSubdirectory(outputName, inheritOutputRulesAndRecording).map(output -> new Outputter((OutputterChecked)output, this.errorReporter));
        }
        catch (OutputWriteFailedException e) {
            this.errorReporter.recordError(Outputter.class, (Throwable)((Object)e));
            return Optional.empty();
        }
    }

    public <T> void write(String outputName, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element) {
        try {
            this.delegate.write(outputName, elementWriter, element);
        }
        catch (OutputWriteFailedException e) {
            this.errorReporter.recordError(Outputter.class, (Throwable)((Object)e));
        }
    }

    public <T> void writeWithIndex(IndexableOutputNameStyle outputNameStyle, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element, String index) {
        try {
            this.delegate.writeWithIndex(outputNameStyle, elementWriter, element, index);
        }
        catch (OutputWriteFailedException e) {
            this.errorReporter.recordError(Outputter.class, (Throwable)((Object)e));
        }
    }

    public Optional<Path> createFilenameForWriting(String outputName, String extension) {
        return this.delegate.createFilenameForWriting(outputName, extension);
    }

    @Generated
    public WriterRouterErrors(Writer delegate, ErrorReporter errorReporter) {
        this.delegate = delegate;
        this.errorReporter = errorReporter;
    }
}

