/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.writer;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.outputter.OutputterChecked;

public class ElementOutputter {
    private OutputterChecked outputter;
    private ExecutionTimeRecorder executionTimeRecorder;
    private Supplier<Optional<Logger>> logger;

    public OutputterChecked deriveSubdirectory(String subdirectoryName, boolean inheritOutputRulesAndRecording) {
        return this.outputter.deriveSubdirectory(subdirectoryName, inheritOutputRulesAndRecording);
    }

    public Path makeOutputPath(Optional<String> suffixWithoutExtension, String extension, String fallbackSuffix) {
        Path path = this.outputter.makeOutputPath(suffixWithoutExtension, extension, fallbackSuffix);
        ElementOutputter.makeAnyNecessarySubdirectories(path);
        return path;
    }

    public OutputWriteSettings getSettings() {
        return this.outputter.getSettings();
    }

    public Optional<ImageFileFormat> getSuggestedFormatToWrite() {
        return this.outputter.getContext().getSuggestedFormatToWrite();
    }

    public MultiLevelOutputEnabled getOutputsEnabled() {
        return this.outputter.getOutputsEnabled();
    }

    public Optional<Logger> logger() {
        return this.logger.get();
    }

    private static void makeAnyNecessarySubdirectories(Path path) {
        if (path.getParent() != null) {
            path.getParent().toFile().mkdirs();
        }
    }

    @Generated
    public ElementOutputter(OutputterChecked outputter, ExecutionTimeRecorder executionTimeRecorder, Supplier<Optional<Logger>> logger) {
        this.outputter = outputter;
        this.executionTimeRecorder = executionTimeRecorder;
        this.logger = logger;
    }

    @Generated
    public OutputterChecked getOutputter() {
        return this.outputter;
    }

    @Generated
    public ExecutionTimeRecorder getExecutionTimeRecorder() {
        return this.executionTimeRecorder;
    }
}

