/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.recorded;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.namestyle.IndexableOutputNameStyle;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.io.output.recorded.RecordedOutputs;
import org.anchoranalysis.io.output.writer.ElementSupplier;
import org.anchoranalysis.io.output.writer.ElementWriterSupplier;
import org.anchoranalysis.io.output.writer.Writer;

class RecordOutputNamesForWriter
implements Writer {
    private final Writer writer;
    private final RecordedOutputs recordedOutputs;
    private final boolean includeIndexableOutputs;

    @Override
    public Optional<OutputterChecked> createSubdirectory(String outputName, boolean inheritOutputRulesAndRecording) throws OutputWriteFailedException {
        Optional<OutputterChecked> outputter = this.writer.createSubdirectory(outputName, inheritOutputRulesAndRecording);
        this.recordedOutputs.add(outputName, outputter.isPresent());
        return outputter;
    }

    @Override
    public <T> boolean write(String outputName, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element) throws OutputWriteFailedException {
        boolean allowed = this.writer.write(outputName, elementWriter, element);
        this.recordedOutputs.add(outputName, allowed);
        return allowed;
    }

    @Override
    public <T> boolean writeWithIndex(IndexableOutputNameStyle outputNameStyle, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element, String index) throws OutputWriteFailedException {
        boolean success = this.writer.writeWithIndex(outputNameStyle, elementWriter, element, index);
        if (this.includeIndexableOutputs) {
            this.recordedOutputs.add(outputNameStyle.getOutputName(), success);
        }
        return success;
    }

    @Override
    public <T> boolean writeWithoutName(String outputName, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element) throws OutputWriteFailedException {
        boolean allowed = this.writer.writeWithoutName(outputName, elementWriter, element);
        this.recordedOutputs.add(outputName, allowed);
        return allowed;
    }

    @Override
    public Optional<Path> createFilenameForWriting(String outputName, String extension) {
        Optional<Path> filename = this.writer.createFilenameForWriting(outputName, extension);
        this.recordedOutputs.add(outputName, filename.isPresent());
        return filename;
    }

    @Generated
    public RecordOutputNamesForWriter(Writer writer, RecordedOutputs recordedOutputs, boolean includeIndexableOutputs) {
        this.writer = writer;
        this.recordedOutputs = recordedOutputs;
        this.includeIndexableOutputs = includeIndexableOutputs;
    }
}

