/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.outputter.directory;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.core.system.path.PathDifference;
import org.anchoranalysis.core.system.path.PathDifferenceException;
import org.anchoranalysis.io.output.outputter.DirectoryCreationParameters;
import org.anchoranalysis.io.output.outputter.directory.LazyDirectoryCreator;
import org.anchoranalysis.io.output.writer.WriterExecuteBeforeEveryOperation;

class LazyDirectoryCreatorPool {
    private final DirectoryCreationParameters parameters;
    private final Path rootDirectory;
    private Map<Path, LazyDirectoryCreator> map = new HashMap<Path, LazyDirectoryCreator>();

    public LazyDirectoryCreatorPool(Path rootDirectory, DirectoryCreationParameters parameters) {
        this.rootDirectory = rootDirectory.normalize();
        this.parameters = parameters;
    }

    public LazyDirectoryCreator getOrCreate(Path directory, Optional<WriterExecuteBeforeEveryOperation> opBefore) throws GetOperationFailedException {
        if (directory.equals(this.rootDirectory)) {
            return this.getRootCreator(opBefore);
        }
        return this.processEachDirectoryComponent(this.differenceFromRoot(directory), opBefore);
    }

    public synchronized Optional<LazyDirectoryCreator> get(Path directory) throws GetOperationFailedException {
        return Optional.ofNullable(this.map.get(this.differenceFromRoot(directory)));
    }

    private LazyDirectoryCreator getRootCreator(Optional<WriterExecuteBeforeEveryOperation> opBefore) {
        return this.getOrCreate(Paths.get("", new String[0]), this.rootDirectory, opBefore, this.parameters.getCallUponDirectoryCreation());
    }

    private LazyDirectoryCreator processEachDirectoryComponent(Path pathDifference, Optional<WriterExecuteBeforeEveryOperation> opBefore) {
        Iterator<Path> iterator = pathDifference.iterator();
        Optional<WriterExecuteBeforeEveryOperation> opBeforeRunning = opBefore;
        LazyDirectoryCreator lazyDirectory = null;
        Path key = null;
        while (iterator.hasNext()) {
            Path next = iterator.next();
            key = key == null ? next : key.resolve(next);
            lazyDirectory = this.getOrCreate(key, this.rootDirectory.resolve(key), opBeforeRunning, Optional.empty());
            opBeforeRunning = Optional.of(lazyDirectory);
        }
        return lazyDirectory;
    }

    private synchronized LazyDirectoryCreator getOrCreate(Path key, Path directoryFull, Optional<WriterExecuteBeforeEveryOperation> opBefore, Optional<Consumer<Path>> opAfter) {
        return this.map.computeIfAbsent(key, path -> new LazyDirectoryCreator(directoryFull, this.parameters.isDeleteExistingDirectory(), opBefore, opAfter));
    }

    private Path differenceFromRoot(Path path) throws GetOperationFailedException {
        try {
            return PathDifference.differenceFrom((Path)this.rootDirectory, (Path)path.normalize()).combined();
        }
        catch (PathDifferenceException e) {
            throw new GetOperationFailedException(path.toString(), (Throwable)e);
        }
    }

    @Generated
    public Path getRootDirectory() {
        return this.rootDirectory;
    }
}

