/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.outputter.directory;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.io.output.error.OutputDirectoryAlreadyExistsException;
import org.anchoranalysis.io.output.writer.WriterExecuteBeforeEveryOperation;
import org.apache.commons.io.FileUtils;

class LazyDirectoryCreator
implements WriterExecuteBeforeEveryOperation {
    private final Path outputDirectory;
    private final boolean deleteExisting;
    private final Optional<WriterExecuteBeforeEveryOperation> parent;
    private final Optional<Consumer<Path>> opAfterCreation;
    private boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        boolean justCreated = false;
        LazyDirectoryCreator lazyDirectoryCreator = this;
        synchronized (lazyDirectoryCreator) {
            if (!this.initialized) {
                this.parent.ifPresent(WriterExecuteBeforeEveryOperation::execute);
                if (this.outputDirectory.toFile().exists()) {
                    if (this.deleteExisting) {
                        FileUtils.deleteQuietly((File)this.outputDirectory.toFile());
                    } else {
                        String line1 = "Output directory already exists.";
                        String line3 = "Consider enabling deleteExisting=\"true\" in experiment.xml";
                        throw new OutputDirectoryAlreadyExistsException(String.format("%s%nBefore proceeding, please delete: %s%n%s", line1, this.outputDirectory, line3));
                    }
                }
                this.outputDirectory.toFile().mkdirs();
                this.initialized = true;
                justCreated = true;
            }
        }
        if (justCreated) {
            this.opAfterCreation.ifPresent(consumer -> consumer.accept(this.outputDirectory));
        }
    }

    @Generated
    public LazyDirectoryCreator(Path outputDirectory, boolean deleteExisting, Optional<WriterExecuteBeforeEveryOperation> parent, Optional<Consumer<Path>> opAfterCreation) {
        this.outputDirectory = outputDirectory;
        this.deleteExisting = deleteExisting;
        this.parent = parent;
        this.opAfterCreation = opAfterCreation;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }
}

