/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.namestyle;

import java.util.Optional;
import org.anchoranalysis.io.output.namestyle.IndexableOutputNameStyle;

public class StringSuffixOutputNameStyle
extends IndexableOutputNameStyle {
    private static final long serialVersionUID = 4582344790084798682L;
    private String outputFormatString;

    public StringSuffixOutputNameStyle() {
    }

    public StringSuffixOutputNameStyle(String outputName, Optional<String> prefix) {
        super(outputName);
        this.outputFormatString = prefix.isPresent() ? prefix.get() + "%s" : "%s";
    }

    @Override
    public IndexableOutputNameStyle duplicate() {
        return new StringSuffixOutputNameStyle(this);
    }

    @Override
    protected String filenameFromOutputFormatString(String outputFormatString, String index) {
        return String.format(outputFormatString, index);
    }

    @Override
    protected String outputFormatString() {
        return this.outputFormatString;
    }

    private StringSuffixOutputNameStyle(StringSuffixOutputNameStyle source) {
        super(source);
    }
}

