/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.enabled;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.io.output.bean.enabled.None;
import org.anchoranalysis.io.output.enabled.SecondLevelOutputEnabled;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.enabled.single.SingleLevelInSet;
import org.anchoranalysis.io.output.enabled.single.SingleLevelOr;
import org.anchoranalysis.io.output.enabled.single.SingleLevelOutputEnabled;

public class OutputEnabledMutable
implements MultiLevelOutputEnabled {
    private Set<String> enabledFirst = new HashSet<String>();
    private SecondLevelOutputEnabled enabledSecond = new SecondLevelOutputEnabled();
    private final Optional<SingleLevelOutputEnabled> additionalSecond;

    public OutputEnabledMutable(String ... outputNames) {
        this(Optional.empty(), outputNames);
    }

    public OutputEnabledMutable(SingleLevelOutputEnabled additionalSecond, String ... outputNames) {
        this(Optional.of(additionalSecond), outputNames);
    }

    private OutputEnabledMutable(Optional<SingleLevelOutputEnabled> additionalSecond, String[] outputNames) {
        this.additionalSecond = additionalSecond;
        OutputEnabledMutable outputEnabledMutable = this;
        Arrays.stream(outputNames).forEach(xva$0 -> outputEnabledMutable.addEnabledOutputFirst((String)xva$0));
    }

    @Override
    public boolean isOutputEnabled(String outputName) {
        return this.enabledFirst.contains(outputName);
    }

    @Override
    public SingleLevelOutputEnabled second(String outputName) {
        Optional<Set<String>> outputs = this.enabledSecond.secondLevelOutputsFor(outputName);
        if (outputs.isPresent()) {
            return this.maybeCombineWithAdditional(outputs.get());
        }
        return this.additionalSecond.orElse(None.INSTANCE);
    }

    public OutputEnabledMutable addEnabledOutputFirst(String ... outputNames) {
        Arrays.stream(outputNames).forEach(this.enabledFirst::add);
        return this;
    }

    public OutputEnabledMutable addEnabledOutputSecond(String outputNameFirstLevel, String ... outputNames) {
        this.enabledSecond.addEnabledOutputs(outputNameFirstLevel, outputNames);
        return this;
    }

    public OutputEnabledMutable addEnabledOutputs(OutputEnabledMutable other) {
        this.enabledFirst.addAll(other.enabledFirst);
        this.enabledSecond.addEnabledOutputs(other.enabledSecond);
        return this;
    }

    private SingleLevelOutputEnabled maybeCombineWithAdditional(Set<String> outputs) {
        SingleLevelInSet existingOutputs = new SingleLevelInSet(outputs);
        if (this.additionalSecond.isPresent()) {
            return new SingleLevelOr(existingOutputs, this.additionalSecond.get());
        }
        return existingOutputs;
    }
}

