/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.bean.path.prefixer;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.exception.BeanStrangeException;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.NamedPath;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;

public abstract class PathPrefixer
extends AnchorBean<PathPrefixer> {
    public abstract DirectoryWithPrefix outFilePrefix(NamedPath var1, Optional<String> var2, PathPrefixerContext var3) throws PathPrefixerException;

    public abstract DirectoryWithPrefix rootDirectoryPrefix(Optional<String> var1, PathPrefixerContext var2) throws PathPrefixerException;

    protected Path resolvePath(String pathToResolve) {
        return this.resolvePath(Paths.get(pathToResolve, new String[0]));
    }

    protected Path resolvePath(Path pathToResolve) {
        if (pathToResolve.isAbsolute()) {
            return pathToResolve;
        }
        Optional localPath = this.getLocalPath();
        if (localPath.isPresent()) {
            assert (!pathToResolve.isAbsolute());
            assert (((Path)localPath.get()).isAbsolute());
            Path parent = ((Path)localPath.get()).getParent();
            return parent.resolve(pathToResolve).normalize();
        }
        throw new BeanStrangeException(String.format("Cannot resolve relative-path: %s as there is no localPath for this bean", pathToResolve));
    }
}

