/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.bean.path.prefixer;

import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixerAvoidResolve;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.NamedPath;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;

public class IncrementingNumber
extends PathPrefixerAvoidResolve {
    private int count = 0;
    @BeanField
    private int numberDigits = 4;

    public IncrementingNumber(String prefix) {
        super(prefix);
    }

    @Override
    public DirectoryWithPrefix outFilePrefixFromPath(NamedPath path, Path root, PathPrefixerContext context) {
        Path combinedDirectory = root.resolve(this.identifier(this.count++));
        return new DirectoryWithPrefix(combinedDirectory);
    }

    private String identifier(int index) {
        String formatSpecifier = "%0" + this.numberDigits + "d";
        return String.format(formatSpecifier, index);
    }

    @Generated
    public IncrementingNumber() {
    }

    @Generated
    public int getNumberDigits() {
        return this.numberDigits;
    }

    @Generated
    public void setNumberDigits(int numberDigits) {
        this.numberDigits = numberDigits;
    }
}

