/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.writer;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.io.output.enabled.single.SingleLevelOutputEnabled;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.namestyle.IndexableOutputNameStyle;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.io.output.writer.ElementSupplier;
import org.anchoranalysis.io.output.writer.ElementWriterSupplier;
import org.anchoranalysis.io.output.writer.Writer;
import org.anchoranalysis.io.output.writer.WriterExecuteBeforeEveryOperation;

public class CheckIfAllowed
implements Writer {
    private final SingleLevelOutputEnabled outputEnabled;
    private final Optional<WriterExecuteBeforeEveryOperation> preop;
    private final Writer writer;

    @Override
    public Optional<OutputterChecked> createSubdirectory(String outputName, boolean inheritOutputRulesAndRecording) throws OutputWriteFailedException {
        if (!this.outputEnabled.isOutputEnabled(outputName)) {
            return Optional.empty();
        }
        this.maybeExecutePreop();
        return this.writer.createSubdirectory(outputName, inheritOutputRulesAndRecording);
    }

    @Override
    public <T> boolean write(String outputName, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element) throws OutputWriteFailedException {
        if (!this.outputEnabled.isOutputEnabled(outputName)) {
            return false;
        }
        this.maybeExecutePreop();
        this.writer.write(outputName, elementWriter, element);
        return true;
    }

    @Override
    public <T> boolean writeWithIndex(IndexableOutputNameStyle outputNameStyle, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element, String index) throws OutputWriteFailedException {
        if (!this.outputEnabled.isOutputEnabled(outputNameStyle.getOutputName())) {
            return false;
        }
        this.maybeExecutePreop();
        return this.writer.writeWithIndex(outputNameStyle, elementWriter, element, index);
    }

    @Override
    public <T> boolean writeWithoutName(String outputName, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element) throws OutputWriteFailedException {
        if (!this.outputEnabled.isOutputEnabled(outputName)) {
            return false;
        }
        this.maybeExecutePreop();
        return this.writer.writeWithoutName(outputName, elementWriter, element);
    }

    @Override
    public Optional<Path> createFilenameForWriting(String outputName, String extension) {
        if (!this.outputEnabled.isOutputEnabled(outputName)) {
            return Optional.empty();
        }
        this.maybeExecutePreop();
        return this.writer.createFilenameForWriting(outputName, extension);
    }

    private void maybeExecutePreop() {
        this.preop.ifPresent(WriterExecuteBeforeEveryOperation::execute);
    }

    public CheckIfAllowed(SingleLevelOutputEnabled outputEnabled, Optional<WriterExecuteBeforeEveryOperation> preop, Writer writer) {
        this.outputEnabled = outputEnabled;
        this.preop = preop;
        this.writer = writer;
    }
}

