/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.writer;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.namestyle.IndexableOutputNameStyle;
import org.anchoranalysis.io.output.namestyle.SimpleOutputNameStyle;
import org.anchoranalysis.io.output.namestyle.WithoutOutputNameStyle;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.io.output.writer.ElementOutputter;
import org.anchoranalysis.io.output.writer.ElementSupplier;
import org.anchoranalysis.io.output.writer.ElementWriterSupplier;
import org.anchoranalysis.io.output.writer.Writer;
import org.anchoranalysis.io.output.writer.WriterExecuteBeforeEveryOperation;

public class AlwaysAllowed
implements Writer {
    private final ElementOutputter outputter;
    private final Optional<WriterExecuteBeforeEveryOperation> preop;

    @Override
    public Optional<OutputterChecked> createSubdirectory(String outputName, boolean inheritOutputRulesAndRecording) throws OutputWriteFailedException {
        this.maybeExecutePreop();
        return Optional.of(this.outputter.deriveSubdirectory(outputName, inheritOutputRulesAndRecording));
    }

    @Override
    public <T> boolean write(String outputName, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element) throws OutputWriteFailedException {
        this.outputter.getExecutionTimeRecorder().recordExecutionTime(AlwaysAllowed.outputNameForWriting(outputName), () -> {
            this.maybeExecutePreop();
            elementWriter.get().write(element.get(), new SimpleOutputNameStyle(outputName), this.outputter);
        });
        return true;
    }

    @Override
    public <T> boolean writeWithIndex(IndexableOutputNameStyle outputNameStyle, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element, String index) throws OutputWriteFailedException {
        return (Boolean)this.outputter.getExecutionTimeRecorder().recordExecutionTime(AlwaysAllowed.outputNameForWriting(outputNameStyle.getOutputName()), () -> {
            this.maybeExecutePreop();
            elementWriter.get().writeWithIndex(element.get(), index, outputNameStyle, this.outputter);
            return true;
        });
    }

    @Override
    public <T> boolean writeWithoutName(String outputName, ElementWriterSupplier<T> elementWriter, ElementSupplier<T> element) throws OutputWriteFailedException {
        this.outputter.getExecutionTimeRecorder().recordExecutionTime(AlwaysAllowed.outputNameForWriting(outputName), () -> {
            this.maybeExecutePreop();
            elementWriter.get().write(element.get(), new WithoutOutputNameStyle(outputName), this.outputter);
        });
        return true;
    }

    @Override
    public Optional<Path> createFilenameForWriting(String outputName, String extension) {
        this.maybeExecutePreop();
        Path path = this.outputter.makeOutputPath(Optional.of(outputName), extension, outputName);
        return Optional.of(path);
    }

    private void maybeExecutePreop() {
        this.preop.ifPresent(WriterExecuteBeforeEveryOperation::execute);
    }

    private static String outputNameForWriting(String outputName) {
        return "Writing output: " + outputName;
    }

    public AlwaysAllowed(ElementOutputter outputter, Optional<WriterExecuteBeforeEveryOperation> preop) {
        this.outputter = outputter;
        this.preop = preop;
    }
}

