/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.path.prefixer;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;

public class OutputPrefixerSettings {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char REPLACEMENT_CHARACTER = '_';
    private Optional<Path> outputDirectory = Optional.empty();
    private Optional<ImageFileFormat> suggestedImageOutputFormat = Optional.empty();
    private boolean outputIncrementingNumberSequence = false;
    private boolean omitExperimentIdentifier = false;
    private boolean outputSuppressDirectories = false;

    public String maybeSuppressDirectories(String identifier, boolean forceSuppressDirectories) {
        if (forceSuppressDirectories || this.outputSuppressDirectories) {
            return OutputPrefixerSettings.replaceSeperatorsWithUnderscore(identifier);
        }
        return identifier;
    }

    public void assignOutputDirectory(Path outputDirectory) {
        this.outputDirectory = Optional.of(outputDirectory);
    }

    public void assignSuggestedImageOutputFormat(ImageFileFormat format) {
        this.suggestedImageOutputFormat = Optional.of(format);
    }

    public void requestOutputIncrementingNumberSequence() {
        this.outputIncrementingNumberSequence = true;
    }

    public void requestOutputSuppressDirectories() {
        this.outputSuppressDirectories = true;
    }

    public void requestOmitExperimentIdentifier() {
        this.omitExperimentIdentifier = true;
    }

    public void checkAbsolutePath() throws PathPrefixerException {
        if (this.outputDirectory.isPresent() && !this.outputDirectory.get().isAbsolute()) {
            throw new PathPrefixerException(String.format("An non-absolute path was passed to %s of %s", this.getClass().getSimpleName(), this.outputDirectory.get()));
        }
    }

    private static String replaceSeperatorsWithUnderscore(String string) {
        return string.replace('\\', '_').replace('/', '_');
    }

    public Optional<Path> getOutputDirectory() {
        return this.outputDirectory;
    }

    public Optional<ImageFileFormat> getSuggestedImageOutputFormat() {
        return this.suggestedImageOutputFormat;
    }

    public boolean isOutputIncrementingNumberSequence() {
        return this.outputIncrementingNumberSequence;
    }

    public boolean isOmitExperimentIdentifier() {
        return this.omitExperimentIdentifier;
    }
}

