/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.outputter.directory;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.io.output.outputter.BindFailedException;
import org.anchoranalysis.io.output.outputter.DirectoryCreationParameters;
import org.anchoranalysis.io.output.outputter.directory.LazyDirectoryCreatorPool;
import org.anchoranalysis.io.output.writer.WriterExecuteBeforeEveryOperation;

class BoundDirectory {
    private final LazyDirectoryCreatorPool directoryCreator;
    private final Optional<WriterExecuteBeforeEveryOperation> parentDirectoryCreator;

    public BoundDirectory(Path directoryPath, DirectoryCreationParameters parameters) throws BindFailedException {
        this.directoryCreator = new LazyDirectoryCreatorPool(directoryPath, parameters);
        this.parentDirectoryCreator = this.creatorForDirectory(directoryPath, Optional.empty());
    }

    public BoundDirectory bindToSubdirectory(Path subdirectoryPath) throws BindFailedException {
        Preconditions.checkArgument((boolean)this.rootDirectoryContains(subdirectoryPath));
        return new BoundDirectory(this.directoryCreator, this.creatorForDirectory(subdirectoryPath, this.parentDirectoryCreator));
    }

    private Optional<WriterExecuteBeforeEveryOperation> creatorForDirectory(Path subdirectoryPath, Optional<WriterExecuteBeforeEveryOperation> opBefore) throws BindFailedException {
        try {
            return Optional.of(this.directoryCreator.getOrCreate(subdirectoryPath, opBefore));
        }
        catch (GetOperationFailedException e) {
            throw new BindFailedException(e);
        }
    }

    private boolean rootDirectoryContains(Path path) {
        return path.normalize().toString().contains(this.directoryCreator.getRootDirectory().toString());
    }

    public BoundDirectory(LazyDirectoryCreatorPool directoryCreator, Optional<WriterExecuteBeforeEveryOperation> parentDirectoryCreator) {
        this.directoryCreator = directoryCreator;
        this.parentDirectoryCreator = parentDirectoryCreator;
    }

    public Optional<WriterExecuteBeforeEveryOperation> getParentDirectoryCreator() {
        return this.parentDirectoryCreator;
    }
}

