/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.outputter;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;
import org.anchoranalysis.io.output.bean.rules.Permissive;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.outputter.BindFailedException;
import org.anchoranalysis.io.output.outputter.DirectoryCreationParameters;
import org.anchoranalysis.io.output.outputter.OutputWriteContext;
import org.anchoranalysis.io.output.outputter.RecordOutputNamesMultiLevel;
import org.anchoranalysis.io.output.outputter.directory.OutputterTarget;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.recorded.MultiLevelRecordedOutputs;
import org.anchoranalysis.io.output.recorded.RecordingWriters;
import org.anchoranalysis.io.output.writer.ElementOutputter;

public class OutputterChecked {
    private final OutputterTarget target;
    private RecordingWriters writers;
    private MultiLevelOutputEnabled outputsEnabled;
    private Optional<MultiLevelRecordedOutputs> recordedOutputs;
    private OutputWriteContext context;
    private Optional<Logger> logger;

    public static OutputterChecked createForDirectoryPermissive(Path pathDirectory, DirectoryCreationParameters directoryCreation, Optional<Logger> logger) throws BindFailedException {
        return OutputterChecked.createWithPrefix(new DirectoryWithPrefix(pathDirectory), Permissive.INSTANCE, new OutputWriteContext(), Optional.empty(), directoryCreation, logger);
    }

    public static OutputterChecked createWithPrefix(DirectoryWithPrefix prefix, MultiLevelOutputEnabled outputEnabled, OutputWriteContext context, Optional<MultiLevelRecordedOutputs> recordedOutputs, DirectoryCreationParameters directoryCreation, Optional<Logger> logger) throws BindFailedException {
        return new OutputterChecked(new OutputterTarget(prefix, directoryCreation), outputEnabled, recordedOutputs, context, logger);
    }

    private OutputterChecked(OutputterTarget target, MultiLevelOutputEnabled outputsEnabled, Optional<MultiLevelRecordedOutputs> recordedOutputs, OutputWriteContext context, Optional<Logger> logger) {
        this.target = target;
        this.context = context;
        this.recordedOutputs = recordedOutputs;
        this.outputsEnabled = this.maybeRecordOutputNames(outputsEnabled);
        this.logger = logger;
        ElementOutputter outputter = new ElementOutputter(this, context.getExecutionTimeRecorder(), () -> this.logger);
        this.writers = new RecordingWriters(outputter, target.getParentDirectoryCreator(), recordedOutputs);
    }

    public OutputterChecked changePrefix(DirectoryWithPrefix prefixToAssign) throws BindFailedException {
        return new OutputterChecked(this.target.changePrefix(prefixToAssign), this.outputsEnabled, this.recordedOutputs, this.context, Optional.empty());
    }

    public OutputterChecked deriveSubdirectory(String subdirectoryName, boolean inheritOutputRulesAndRecording) {
        Path pathSubdirectory = this.makeOutputPath(subdirectoryName);
        try {
            return new OutputterChecked(this.target.changePrefix(new DirectoryWithPrefix(pathSubdirectory)), inheritOutputRulesAndRecording ? this.outputsEnabled : Permissive.INSTANCE, inheritOutputRulesAndRecording ? this.recordedOutputs : Optional.empty(), this.context, this.logger);
        }
        catch (BindFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    public OutputWriteSettings getSettings() {
        return this.context.getSettings();
    }

    public Path getOutputDirectory() {
        return this.target.getDirectory();
    }

    public Path makeOutputPath(String suffix) {
        return this.target.pathCreator().makePathAbsolute(Optional.of(suffix), Optional.empty(), suffix);
    }

    public Path makeOutputPath(Optional<String> suffixWithoutExtension, String extension, String fallbackSuffix) {
        return this.target.pathCreator().makePathAbsolute(suffixWithoutExtension, Optional.of(extension), fallbackSuffix);
    }

    public void assignLogger(Logger logger) {
        this.logger = Optional.of(logger);
    }

    public DirectoryWithPrefix getPrefix() {
        return this.target.getPrefix();
    }

    private MultiLevelOutputEnabled maybeRecordOutputNames(MultiLevelOutputEnabled outputsEnabled) {
        if (this.recordedOutputs.isPresent()) {
            return new RecordOutputNamesMultiLevel(outputsEnabled, this.recordedOutputs.get());
        }
        return outputsEnabled;
    }

    public RecordingWriters getWriters() {
        return this.writers;
    }

    public MultiLevelOutputEnabled getOutputsEnabled() {
        return this.outputsEnabled;
    }

    public OutputWriteContext getContext() {
        return this.context;
    }
}

