/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.outputter;

import java.util.Optional;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.core.time.ExecutionTimeRecorderIgnore;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;

public class OutputWriteContext {
    private final OutputWriteSettings settings;
    private final Optional<ImageFileFormat> suggestedFormatToWrite;
    private ExecutionTimeRecorder executionTimeRecorder;

    public OutputWriteContext() {
        this(OutputWriteContext.createAndInitializeSettings());
    }

    public OutputWriteContext(OutputWriteSettings settings) {
        this.settings = settings;
        this.suggestedFormatToWrite = Optional.empty();
        this.executionTimeRecorder = ExecutionTimeRecorderIgnore.instance();
    }

    private static OutputWriteSettings createAndInitializeSettings() {
        OutputWriteSettings settings = new OutputWriteSettings();
        try {
            settings.initialize(new BeanInstanceMap());
        }
        catch (BeanMisconfiguredException e) {
            throw new AnchorImpossibleSituationException();
        }
        return settings;
    }

    public OutputWriteContext(OutputWriteSettings settings, Optional<ImageFileFormat> suggestedFormatToWrite, ExecutionTimeRecorder executionTimeRecorder) {
        this.settings = settings;
        this.suggestedFormatToWrite = suggestedFormatToWrite;
        this.executionTimeRecorder = executionTimeRecorder;
    }

    public OutputWriteSettings getSettings() {
        return this.settings;
    }

    public Optional<ImageFileFormat> getSuggestedFormatToWrite() {
        return this.suggestedFormatToWrite;
    }

    public ExecutionTimeRecorder getExecutionTimeRecorder() {
        return this.executionTimeRecorder;
    }
}

