/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.enabled;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

class SecondLevelOutputEnabled {
    private Map<String, Set<String>> map = new HashMap<String, Set<String>>();

    SecondLevelOutputEnabled() {
    }

    public void addEnabledOutputs(String outputNameFirstLevel, String[] outputNames) {
        this.addToSecond(outputNameFirstLevel, set -> Arrays.stream(outputNames).forEach(set::add));
    }

    public Optional<Set<String>> secondLevelOutputsFor(String outputNameFirstLevel) {
        return Optional.ofNullable(this.map.get(outputNameFirstLevel));
    }

    public void addEnabledOutputs(String outputNameFirstLevel, Set<String> outputNames) {
        this.addToSecond(outputNameFirstLevel, set -> set.addAll(outputNames));
    }

    public void addEnabledOutputs(SecondLevelOutputEnabled other) {
        for (String key : other.map.keySet()) {
            this.addEnabledOutputs(key, other.map.get(key));
        }
    }

    private void addToSecond(String outputNameFirstLevel, Consumer<Set<String>> consumer) {
        Set set = this.map.computeIfAbsent(outputNameFirstLevel, name -> new HashSet());
        consumer.accept(set);
    }
}

