/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.bean.path.prefixer;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixer;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.NamedPath;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;

public abstract class PathPrefixerAvoidResolve
extends PathPrefixer {
    @BeanField
    @AllowEmpty
    private String prefix = "";
    private Path resolvedRoot = null;

    protected PathPrefixerAvoidResolve(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public DirectoryWithPrefix rootDirectoryPrefix(Optional<String> experimentIdentifier, PathPrefixerContext context) throws PathPrefixerException {
        return new DirectoryWithPrefix(this.resolveRoot(experimentIdentifier, context));
    }

    @Override
    public DirectoryWithPrefix outFilePrefix(NamedPath path, Optional<String> experimentIdentifier, PathPrefixerContext context) throws PathPrefixerException {
        Path root = this.resolveRoot(experimentIdentifier, context);
        return this.outFilePrefixFromPath(path, root, context);
    }

    public DirectoryWithPrefix rootDirectoryPrefixAvoidResolve(Optional<String> experimentIdentifier) {
        StringBuilder folder = new StringBuilder(this.getPrefix() + File.separator);
        if (experimentIdentifier.isPresent()) {
            folder.append(experimentIdentifier.get());
            folder.append(File.separator);
        }
        return new DirectoryWithPrefix(Paths.get(folder.toString(), new String[0]));
    }

    public DirectoryWithPrefix outFilePrefixAvoidResolve(NamedPath path, Optional<String> experimentIdentifier, PathPrefixerContext context) throws PathPrefixerException {
        return this.outFilePrefixFromPath(path, this.rootDirectoryPrefixAvoidResolve(experimentIdentifier).getDirectory(), context);
    }

    public abstract DirectoryWithPrefix outFilePrefixFromPath(NamedPath var1, Path var2, PathPrefixerContext var3) throws PathPrefixerException;

    private Path resolveRoot(Optional<String> experimentIdentifier, PathPrefixerContext context) {
        if (this.resolvedRoot == null) {
            this.resolvedRoot = this.selectResolvedPath(context);
            if (experimentIdentifier.isPresent()) {
                this.resolvedRoot = this.resolvedRoot.resolve(experimentIdentifier.get());
            }
        }
        return this.resolvedRoot;
    }

    private Path selectResolvedPath(PathPrefixerContext context) {
        if (!this.prefix.isEmpty()) {
            return this.resolvePath(this.prefix);
        }
        return context.getPrefixer().getOutputDirectory().orElseGet(PathPrefixerAvoidResolve::temporaryDirectory);
    }

    private static Path temporaryDirectory() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public PathPrefixerAvoidResolve() {
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

