/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.path.matcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.functional.checked.CheckedPredicate;
import org.anchoranalysis.io.input.path.matcher.FindFilesException;

public class DualPathPredicates {
    private CheckedPredicate<Path, IOException> file;
    private CheckedPredicate<Path, IOException> directory;

    public boolean matchFile(Path path) throws IOException {
        return this.file.test((Object)path);
    }

    public void consumeMatchingFiles(List<Path> paths, Consumer<File> consumerMatching) throws FindFilesException {
        for (Path path : paths) {
            try {
                if (!this.file.test((Object)path)) continue;
                consumerMatching.accept(path.normalize().toFile());
            }
            catch (IOException e) {
                throw new FindFilesException("An error occurred evaluating the predicate on a file-path", e);
            }
        }
    }

    public List<Path> matchingLeafDirectories(List<Path> leafDirectories) throws FindFilesException {
        try {
            return FunctionalList.filterToList(leafDirectories, IOException.class, this.directory);
        }
        catch (IOException e) {
            throw new FindFilesException("An error occurred evaluating the predicate on a file-path", e);
        }
    }

    @Generated
    public DualPathPredicates(CheckedPredicate<Path, IOException> file, CheckedPredicate<Path, IOException> directory) {
        this.file = file;
        this.directory = directory;
    }

    @Generated
    public CheckedPredicate<Path, IOException> getDirectory() {
        return this.directory;
    }
}

