/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.file.NamedFile;

public abstract class SingleFileInputBase
implements InputFromManager {
    private NamedFile file;

    protected SingleFileInputBase(NamedFile file) {
        this.file = file;
        Preconditions.checkArgument((!file.getIdentifier().isEmpty() ? 1 : 0) != 0);
    }

    @Override
    public String identifier() {
        return this.file.getIdentifier();
    }

    @Override
    public Optional<Path> pathForBinding() {
        return Optional.of(this.file.getPath());
    }

    public String toString() {
        return this.identifier();
    }

    public File getFile() {
        return this.file.getFile();
    }
}

